/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.webdav;

import app.termora.plugins.webdav.WebDAVFileSystemProvider;
import app.termora.plugins.webdav.WebDAVPath;
import app.termora.transfer.s3.S3FileAttributes;
import app.termora.transfer.s3.S3FileSystem;
import app.termora.transfer.s3.S3FileSystemProvider;
import app.termora.transfer.s3.S3Path;
import com.github.sardine.Sardine;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/webdav/WebDAVFileSystem;", "Lapp/termora/transfer/s3/S3FileSystem;", "sardine", "Lcom/github/sardine/Sardine;", "endpoint", "", "authorization", "<init>", "(Lcom/github/sardine/Sardine;Ljava/lang/String;Ljava/lang/String;)V", "create", "Lapp/termora/transfer/s3/S3Path;", "root", "names", "", "close", "", "webdav"})
public final class WebDAVFileSystem
extends S3FileSystem {
    @NotNull
    private final Sardine sardine;

    public WebDAVFileSystem(@NotNull Sardine sardine2, @NotNull String endpoint, @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)sardine2, (String)"sardine");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        super((S3FileSystemProvider)new WebDAVFileSystemProvider(sardine2, endpoint, authorization));
        this.sardine = sardine2;
    }

    @NotNull
    protected S3Path create(@Nullable String root, @NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        WebDAVPath path = new WebDAVPath(this, root, names);
        if (names.isEmpty()) {
            path.setAttributes(S3FileAttributes.copy$default((S3FileAttributes)path.getAttributes(), (long)0L, (long)0L, (long)0L, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)0L, (int)239, null));
        }
        return path;
    }

    public void close() {
        this.sardine.shutdown();
        super.close();
    }
}

