/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.webdav;

import app.termora.Application;
import app.termora.ResponseException;
import app.termora.transfer.s3.S3FileAttributes;
import app.termora.transfer.s3.S3FileSystemProvider;
import app.termora.transfer.s3.S3Path;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J1\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001a\u0010\u0017\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\"\u0006\u0012\u0002\b\u00030\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J)\u0010\u001e\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u0018\"\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lapp/termora/plugins/webdav/WebDAVFileSystemProvider;", "Lapp/termora/transfer/s3/S3FileSystemProvider;", "sardine", "Lcom/github/sardine/Sardine;", "endpoint", "", "authorization", "<init>", "(Lcom/github/sardine/Sardine;Ljava/lang/String;Ljava/lang/String;)V", "getScheme", "getOutputStream", "Ljava/io/OutputStream;", "path", "Lapp/termora/transfer/s3/S3Path;", "getInputStream", "Ljava/io/InputStream;", "createStreamer", "fetchChildren", "", "createDirectory", "", "dir", "Ljava/nio/file/Path;", "attrs", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "isDirectory", "", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Lapp/termora/transfer/s3/S3Path;[Ljava/nio/file/AccessMode;)V", "getFullUrl", "webdav"})
public final class WebDAVFileSystemProvider
extends S3FileSystemProvider {
    @NotNull
    private final Sardine sardine;
    @NotNull
    private final String endpoint;
    @NotNull
    private final String authorization;

    public WebDAVFileSystemProvider(@NotNull Sardine sardine2, @NotNull String endpoint, @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)sardine2, (String)"sardine");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        this.sardine = sardine2;
        this.endpoint = endpoint;
        this.authorization = authorization;
    }

    @Nullable
    public String getScheme() {
        return "webdav";
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.createStreamer(path);
    }

    @NotNull
    public InputStream getInputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = this.sardine.get(this.getFullUrl((Path)path));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"get(...)");
        return inputStream;
    }

    private final OutputStream createStreamer(S3Path path) {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        AtomicReference<Throwable> exception = new AtomicReference<Throwable>();
        Thread thread2 = Thread.ofVirtual().start(() -> WebDAVFileSystemProvider.createStreamer$lambda$0(this, path, exception, pis));
        return new OutputStream(exception, pos, thread2){
            final /* synthetic */ AtomicReference<Throwable> $exception;
            final /* synthetic */ PipedOutputStream $pos;
            final /* synthetic */ Thread $thread;
            {
                this.$exception = $exception;
                this.$pos = $pos;
                this.$thread = $thread;
            }

            public void write(int b) {
                Throwable exception;
                Throwable throwable = exception = this.$exception.get();
                if (throwable != null) {
                    throw throwable;
                }
                this.$pos.write(b);
            }

            public void close() {
                this.$pos.close();
                if (this.$thread.isAlive()) {
                    this.$thread.join();
                }
            }
        };
    }

    @NotNull
    public List<S3Path> fetchChildren(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List paths = new ArrayList();
        List resources = this.sardine.list(this.getFullUrl((Path)path));
        int n = resources.size();
        for (int i = 1; i < n; ++i) {
            DavResource resource = (DavResource)resources.get(i);
            S3Path p = (S3Path)path.resolve(resource.getName());
            S3FileAttributes s3FileAttributes = p.getAttributes();
            boolean bl = resource.isDirectory();
            boolean bl2 = !resource.isDirectory();
            Long l = resource.getContentLength();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getContentLength(...)");
            long l2 = ((Number)l).longValue();
            long l3 = resource.getModified().getTime();
            p.setAttributes(S3FileAttributes.copy$default((S3FileAttributes)s3FileAttributes, (long)l3, (long)0L, (long)0L, (boolean)bl2, (boolean)bl, (boolean)false, (boolean)false, (long)l2, (int)102, null));
            Intrinsics.checkNotNull((Object)p);
            paths.add(p);
        }
        return paths;
    }

    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.sardine.createDirectory(this.getFullUrl(dir));
    }

    public void delete(@NotNull S3Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.sardine.delete(this.getFullUrl((Path)path));
    }

    public void checkAccess(@NotNull S3Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        try {
            if (!this.sardine.exists(this.getFullUrl((Path)path))) {
                throw new NoSuchFileException(PathsKt.getName((Path)((Path)path)));
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException) {
                throw e;
            }
            throw new NoSuchFileException(e.getMessage());
        }
    }

    private final String getFullUrl(Path path) {
        String string = new URI(null, null, ((Object)path.toAbsolutePath()).toString(), null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String pathname = string;
        return this.endpoint + pathname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createStreamer$lambda$0(WebDAVFileSystemProvider this$0, S3Path $path, AtomicReference $exception, PipedInputStream $pis) {
        try {
            Request.Builder builder2 = new Request.Builder().url(this$0.endpoint + ((Object)((Path)$path).toAbsolutePath()).toString()).put(new RequestBody($pis){
                final /* synthetic */ PipedInputStream $pis;
                {
                    this.$pis = $pis;
                }

                public MediaType contentType() {
                    return null;
                }

                public long contentLength() {
                    return -1L;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    Closeable closeable = (Closeable)Okio.source((InputStream)this.$pis);
                    Throwable throwable = null;
                    try {
                        Source it = (Source)closeable;
                        boolean bl = false;
                        long l = sink.writeAll(it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            });
            if (!StringsKt.isBlank((CharSequence)this$0.authorization)) {
                builder2.header("Authorization", this$0.authorization);
            }
            Response response = Application.INSTANCE.getHttpClient().newCall(builder2.build()).execute();
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            if (!response.isSuccessful()) {
                throw new ResponseException(response.code(), response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            $exception.set(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)$pis);
        }
    }
}

