/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.webdav;

import app.termora.AuthenticationType;
import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.ProxyType;
import app.termora.plugins.webdav.WebDAVFileSystem;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Credentials;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/webdav/WebDAVProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "getProtocol", "", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "webdav"})
public final class WebDAVProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<WebDAVProtocolProvider> instance$delegate = LazyKt.lazy(WebDAVProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "WebDAV";

    private WebDAVProtocolProvider() {
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getDav();
    }

    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Host host = requester.getHost();
        Sardine sardine2 = host.getAuthentication().getType() != AuthenticationType.No ? (host.getProxy().getType() != ProxyType.No ? SardineFactory.begin((String)host.getUsername(), (String)host.getAuthentication().getPassword(), (ProxySelector)new ProxySelector(host){
            final /* synthetic */ Host $host;
            {
                this.$host = $host;
            }

            public List<Proxy> select(URI uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                if (this.$host.getProxy().getType() == ProxyType.HTTP) {
                    return CollectionsKt.listOf((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.$host.getProxy().getHost(), this.$host.getProxy().getPort())));
                }
                return CollectionsKt.listOf((Object)new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.$host.getProxy().getHost(), this.$host.getProxy().getPort())));
            }

            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)sa, (String)"sa");
                Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
                throw ioe;
            }
        }) : SardineFactory.begin((String)host.getUsername(), (String)host.getAuthentication().getPassword())) : SardineFactory.begin();
        String authorization = host.getAuthentication().getType() != AuthenticationType.No ? Credentials.basic$default((String)host.getUsername(), (String)host.getAuthentication().getPassword(), null, (int)4, null) : "";
        String defaultPath = host.getOptions().getSftpDefaultDirectory();
        Intrinsics.checkNotNull((Object)sardine2);
        String string = StringUtils.removeEnd((String)host.getHost(), (String)"/");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeEnd(...)");
        WebDAVFileSystem fs = new WebDAVFileSystem(sardine2, string, authorization);
        FileSystem fileSystem = (FileSystem)((Object)fs);
        Path path = fs.getPath(defaultPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new PathHandler(fileSystem, path);
    }

    public boolean isTransfer() {
        return super.isTransfer();
    }

    public boolean isTransient() {
        return super.isTransient();
    }

    public int ordered() {
        return super.ordered();
    }

    private static final WebDAVProtocolProvider instance_delegate$lambda$0() {
        return new WebDAVProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/webdav/WebDAVProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/webdav/WebDAVProtocolProvider;", "getInstance", "()Lapp/termora/plugins/webdav/WebDAVProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "webdav"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebDAVProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (WebDAVProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

