/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.cos;

import app.termora.AuthenticationType;
import app.termora.Proxy;
import app.termora.ProxyType;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.region.Region;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/termora/plugins/cos/COSClientHandler;", "Ljava/io/Closeable;", "cred", "Lcom/qcloud/cos/auth/BasicCOSCredentials;", "proxy", "Lapp/termora/Proxy;", "buckets", "", "Lcom/qcloud/cos/model/Bucket;", "<init>", "(Lcom/qcloud/cos/auth/BasicCOSCredentials;Lapp/termora/Proxy;Ljava/util/List;)V", "getBuckets", "()Ljava/util/List;", "clients", "", "", "Lcom/qcloud/cos/COSClient;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClientForBucket", "bucket", "close", "", "Companion", "cos"})
@SourceDebugExtension(value={"SMAP\nCOSClientHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 COSClientHandler.kt\napp/termora/plugins/cos/COSClientHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n230#2,2:70\n216#3,2:72\n*S KotlinDebug\n*F\n+ 1 COSClientHandler.kt\napp/termora/plugins/cos/COSClientHandler\n*L\n50#1:70,2\n62#1:72,2\n*E\n"})
public final class COSClientHandler
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BasicCOSCredentials cred;
    @NotNull
    private final Proxy proxy;
    @NotNull
    private final List<Bucket> buckets;
    @NotNull
    private final Map<String, COSClient> clients;
    @NotNull
    private final AtomicBoolean closed;

    public COSClientHandler(@NotNull BasicCOSCredentials cred, @NotNull Proxy proxy, @NotNull List<? extends Bucket> buckets) {
        Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
        this.cred = cred;
        this.proxy = proxy;
        this.buckets = buckets;
        this.clients = new LinkedHashMap();
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final List<Bucket> getBuckets() {
        return this.buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final COSClient getClientForBucket(@NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        if (this.closed.get()) {
            throw new IllegalStateException("Client already closed");
        }
        COSClientHandler cOSClientHandler = this;
        synchronized (cOSClientHandler) {
            Bucket bucket2;
            block7: {
                Object element$iv2;
                block6: {
                    boolean bl = false;
                    Iterable $this$first$iv = this.buckets;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        Bucket it = (Bucket)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)bucket)) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                bucket2 = (Bucket)element$iv2;
                if (!this.clients.containsKey(bucket2.getLocation())) break block7;
                COSClient cOSClient = (COSClient)MapsKt.getValue(this.clients, (Object)bucket2.getLocation());
                return cOSClient;
            }
            Map<String, COSClient> map = this.clients;
            String string = bucket2.getLocation();
            String string2 = bucket2.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocation(...)");
            COSClient cOSClient = Companion.createCOSClient(this.cred, string2, this.proxy);
            map.put(string, cOSClient);
            COSClient cOSClient2 = (COSClient)MapsKt.getValue(this.clients, (Object)bucket2.getLocation());
            return cOSClient2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            COSClientHandler cOSClientHandler = this;
            synchronized (cOSClientHandler) {
                boolean bl = false;
                Map<String, COSClient> $this$forEach$iv = this.clients;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, COSClient>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, COSClient> element$iv;
                    Map.Entry<String, COSClient> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    it.getValue().shutdown();
                }
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/cos/COSClientHandler$Companion;", "", "<init>", "()V", "createCOSClient", "Lcom/qcloud/cos/COSClient;", "cred", "Lcom/qcloud/cos/auth/BasicCOSCredentials;", "region", "", "proxy", "Lapp/termora/Proxy;", "cos"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final COSClient createCOSClient(@NotNull BasicCOSCredentials cred, @NotNull String region, @NotNull Proxy proxy) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            ClientConfig clientConfig = new ClientConfig();
            if (!StringsKt.isBlank((CharSequence)region)) {
                clientConfig.setRegion(new Region(region));
            }
            clientConfig.setPrintShutdownStackTrace(false);
            if (proxy.getType() == ProxyType.HTTP) {
                clientConfig.setHttpProxyIp(proxy.getHost());
                clientConfig.setHttpProxyPort(proxy.getPort());
                if (proxy.getAuthenticationType() == AuthenticationType.Password) {
                    clientConfig.setProxyPassword(proxy.getPassword());
                    clientConfig.setProxyUsername(proxy.getUsername());
                }
            }
            return new COSClient((COSCredentials)cred, clientConfig);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

