/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.cos;

import app.termora.plugins.cos.COSClientHandler;
import app.termora.transfer.s3.S3FileAttributes;
import app.termora.transfer.s3.S3FileSystem;
import app.termora.transfer.s3.S3FileSystemProvider;
import app.termora.transfer.s3.S3Path;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.AccessMode;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J)\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/plugins/cos/COSFileSystemProvider;", "Lapp/termora/transfer/s3/S3FileSystemProvider;", "clientHandler", "Lapp/termora/plugins/cos/COSClientHandler;", "<init>", "(Lapp/termora/plugins/cos/COSClientHandler;)V", "getScheme", "", "getOutputStream", "Ljava/io/OutputStream;", "path", "Lapp/termora/transfer/s3/S3Path;", "getInputStream", "Ljava/io/InputStream;", "createStreamer", "fetchChildren", "", "delete", "", "isDirectory", "", "checkAccess", "modes", "", "Ljava/nio/file/AccessMode;", "(Lapp/termora/transfer/s3/S3Path;[Ljava/nio/file/AccessMode;)V", "cos"})
public final class COSFileSystemProvider
extends S3FileSystemProvider {
    @NotNull
    private final COSClientHandler clientHandler;

    public COSFileSystemProvider(@NotNull COSClientHandler clientHandler) {
        Intrinsics.checkNotNullParameter((Object)clientHandler, (String)"clientHandler");
        this.clientHandler = clientHandler;
    }

    @Nullable
    public String getScheme() {
        return "cos";
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.createStreamer(path);
    }

    @NotNull
    public InputStream getInputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        COSClient client = this.clientHandler.getClientForBucket(path.getBucketName());
        COSObjectInputStream cOSObjectInputStream = client.getObject(path.getBucketName(), path.getObjectName()).getObjectContent();
        Intrinsics.checkNotNullExpressionValue((Object)cOSObjectInputStream, (String)"getObjectContent(...)");
        return (InputStream)cOSObjectInputStream;
    }

    private final OutputStream createStreamer(S3Path path) {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        AtomicReference<Throwable> exception = new AtomicReference<Throwable>();
        Thread thread = Thread.ofVirtual().start(() -> COSFileSystemProvider.createStreamer$lambda$0(this, path, pis, exception));
        return new OutputStream(exception, pos, thread){
            final /* synthetic */ AtomicReference<Throwable> $exception;
            final /* synthetic */ PipedOutputStream $pos;
            final /* synthetic */ Thread $thread;
            {
                this.$exception = $exception;
                this.$pos = $pos;
                this.$thread = $thread;
            }

            public void write(int b) {
                Throwable exception;
                Throwable throwable = exception = this.$exception.get();
                if (throwable != null) {
                    throw throwable;
                }
                this.$pos.write(b);
            }

            public void close() {
                this.$pos.close();
                if (this.$thread.isAlive()) {
                    this.$thread.join();
                }
            }
        };
    }

    @NotNull
    public List<S3Path> fetchChildren(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List paths = new ArrayList();
        if (path.isRoot()) {
            for (Bucket bucket : this.clientHandler.getBuckets()) {
                S3Path p = (S3Path)path.resolve(bucket.getName());
                long l = bucket.getCreationDate().toInstant().toEpochMilli();
                p.setAttributes(new S3FileAttributes(l, 0L, 0L, false, true, false, false, 0L, 238, null));
                Intrinsics.checkNotNull((Object)p);
                paths.add(p);
            }
            return paths;
        }
        String nextMarker = "";
        int maxKeys = 100;
        String bucketName = path.getBucketName();
        while (true) {
            S3Path p;
            ListObjectsRequest request = new ListObjectsRequest().withBucketName(bucketName).withMaxKeys(Integer.valueOf(maxKeys)).withDelimiter(((S3FileSystem)path.getFileSystem()).getSeparator());
            if (!StringsKt.isBlank((CharSequence)path.getObjectName())) {
                request.withPrefix(path.getObjectName() + ((S3FileSystem)path.getFileSystem()).getSeparator());
            }
            if (!StringsKt.isBlank((CharSequence)nextMarker)) {
                request.withMarker(nextMarker);
            }
            ObjectListing objectListing = this.clientHandler.getClientForBucket(bucketName).listObjects(request);
            for (String e : objectListing.getCommonPrefixes()) {
                p = (S3Path)path.getBucket().resolve(e);
                p.setAttributes(S3FileAttributes.copy$default((S3FileAttributes)p.getAttributes(), (long)0L, (long)0L, (long)0L, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)0L, (int)239, null));
                Intrinsics.checkNotNull((Object)p);
                this.delete((Path)p);
                paths.add(p);
            }
            for (String e : objectListing.getObjectSummaries()) {
                p = (S3Path)path.getBucket().resolve(e.getKey());
                S3FileAttributes s3FileAttributes = p.getAttributes();
                long l = e.getSize();
                long l2 = e.getLastModified().getTime();
                p.setAttributes(S3FileAttributes.copy$default((S3FileAttributes)s3FileAttributes, (long)l2, (long)0L, (long)0L, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (long)l, (int)118, null));
                Intrinsics.checkNotNull((Object)p);
                paths.add(p);
            }
            if (!objectListing.isTruncated()) break;
            Intrinsics.checkNotNullExpressionValue((Object)objectListing.getNextMarker(), (String)"getNextMarker(...)");
        }
        List list = (List)this.getDirectories().get(((Object)((Path)path).toAbsolutePath()).toString());
        paths.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        return paths;
    }

    public void delete(@NotNull S3Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!isDirectory) {
            this.clientHandler.getClientForBucket(path.getBucketName()).deleteObject(path.getBucketName(), path.getObjectName());
        }
    }

    public void checkAccess(@NotNull S3Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        try {
            COSClient client = this.clientHandler.getClientForBucket(path.getBucketName());
            if (!client.doesObjectExist(path.getBucketName(), path.getObjectName())) {
                throw new NoSuchFileException(path.getObjectName());
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException) {
                throw e;
            }
            throw new NoSuchFileException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createStreamer$lambda$0(COSFileSystemProvider this$0, S3Path $path, PipedInputStream $pis, AtomicReference $exception) {
        try {
            COSClient client = this$0.clientHandler.getClientForBucket($path.getBucketName());
            client.putObject(new PutObjectRequest($path.getBucketName(), $path.getObjectName(), (InputStream)$pis, new ObjectMetadata()));
        }
        catch (Exception e) {
            $exception.set(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)$pis);
        }
    }
}

