/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.internal.ObjectRestoreResult;
import com.qcloud.cos.internal.ServerSideEncryptionResult;
import com.qcloud.cos.model.CosServiceResult;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadata
extends CosServiceResult
implements ServerSideEncryptionResult,
ObjectExpirationResult,
ObjectRestoreResult,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> userMetadata;
    private Map<String, Object> metadata;
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;
    private boolean isDeleteMarker;
    private boolean isFileModeDir;
    private CIUploadResult ciUploadResult;

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public void setHeader(String key, Object value) {
        long contentLength;
        String key_lower = key.toLowerCase();
        if (key_lower.equals("content-length") && (contentLength = Long.parseLong(value.toString())) < 0L) {
            throw new CosClientException("The specified header content-length should be greater than or equal to 0");
        }
        this.metadata.put(key, value);
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Object getRawMetadataValue(String key) {
        return this.metadata.get(key);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.setHeader("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentLanguage() {
        return (String)this.metadata.get("Content-Language");
    }

    public void setContentLanguage(String contentLanguage) {
        this.metadata.put("Content-Language", contentLanguage);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", md5Base64);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public void setETag(String etagValve) {
        this.metadata.put("ETag", etagValve);
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-cos-version-id");
    }

    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-cos-server-side-encryption");
    }

    public void setServerSideEncryption(String serverSideEncryption) {
        this.metadata.put("x-cos-server-side-encryption", serverSideEncryption);
    }

    public void setSecurityToken(String securityToken) {
        this.metadata.put("x-cos-security-token", securityToken);
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    @Override
    public void setExpirationTimeRuleId(String expirationTimeRuleId) {
        this.expirationTimeRuleId = expirationTimeRuleId;
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    @Override
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    @Override
    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    @Override
    public void setOngoingRestore(boolean ongoingRestore) {
        this.ongoingRestore = ongoingRestore;
    }

    @Override
    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public boolean isDeleteMarker() {
        return this.isDeleteMarker;
    }

    public void setDeleteMarker(boolean isDeleteMarker) {
        this.isDeleteMarker = isDeleteMarker;
    }

    public boolean isFileModeDir() {
        return this.isFileModeDir;
    }

    public void setFileModeDir(boolean isFileModeDir) {
        this.isFileModeDir = isFileModeDir;
    }

    public String getUserMetaDataOf(String key) {
        return this.userMetadata == null ? null : this.userMetadata.get(key);
    }

    public ObjectMetadata() {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
        this.isFileModeDir = false;
    }

    private ObjectMetadata(ObjectMetadata from) {
        this.userMetadata = from.userMetadata == null ? null : new HashMap<String, String>(from.userMetadata);
        this.metadata = from.metadata == null ? null : new HashMap<String, Object>(from.metadata);
        this.expirationTime = from.expirationTime;
        this.expirationTimeRuleId = from.expirationTimeRuleId;
        this.httpExpiresDate = from.httpExpiresDate;
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }

    @Override
    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-cos-server-side-encryption");
    }

    @Override
    public void setSSEAlgorithm(String algorithm) {
        this.metadata.put("x-cos-server-side-encryption", algorithm);
    }

    @Override
    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-cos-server-side-encryption-customer-algorithm");
    }

    @Override
    public void setSSECustomerAlgorithm(String algorithm) {
        this.metadata.put("x-cos-server-side-encryption-customer-algorithm", algorithm);
    }

    @Override
    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-cos-server-side-encryption-customer-key-MD5");
    }

    @Override
    public void setSSECustomerKeyMd5(String md5Digest) {
        this.metadata.put("x-cos-server-side-encryption-customer-key-MD5", md5Digest);
    }

    public String getStorageClass() {
        Object storageClass = this.metadata.get("x-cos-storage-class");
        if (storageClass == null) {
            return null;
        }
        return storageClass.toString();
    }

    public StorageClass getStorageClassEnum() {
        String storageClassStr = this.getStorageClass();
        StorageClass storageClass = null;
        if (storageClassStr != null) {
            storageClass = StorageClass.fromValue(storageClassStr);
        }
        return storageClass;
    }

    public String getSSECOSKmsKeyId() {
        return (String)this.metadata.get("x-cos-server-side-encryption-qcloud-kms-key-id");
    }

    public String getCrc64Ecma() {
        return (String)this.metadata.get("x-cos-hash-crc64ecma");
    }

    public String getCrc32c() {
        return (String)this.metadata.get("x-cos-hash-crc32c");
    }

    @Override
    public String getRequestId() {
        return (String)this.metadata.get("x-cos-request-id");
    }

    public CIUploadResult getCiUploadResult() {
        return this.ciUploadResult;
    }

    public void setCiUploadResult(CIUploadResult ciUploadResult) {
        this.ciUploadResult = ciUploadResult;
    }

    public boolean isNeedPreflight() {
        if (this.metadata.containsKey("x-cos-preflight")) {
            String preflightStatus = (String)this.metadata.get("x-cos-preflight");
            return preflightStatus.equalsIgnoreCase("true");
        }
        return false;
    }
}

