/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.obs;

import app.termora.AuthenticationType;
import app.termora.Proxy;
import app.termora.ProxyType;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.model.ObsBucket;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/termora/plugins/obs/OBSClientHandler;", "Ljava/io/Closeable;", "cred", "Lcom/obs/services/IObsCredentialsProvider;", "proxy", "Lapp/termora/Proxy;", "buckets", "", "Lcom/obs/services/model/ObsBucket;", "<init>", "(Lcom/obs/services/IObsCredentialsProvider;Lapp/termora/Proxy;Ljava/util/List;)V", "getBuckets", "()Ljava/util/List;", "clients", "", "", "Lcom/obs/services/ObsClient;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClientForBucket", "bucket", "close", "", "Companion", "obs"})
@SourceDebugExtension(value={"SMAP\nOBSClientHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OBSClientHandler.kt\napp/termora/plugins/obs/OBSClientHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,81:1\n230#2,2:82\n216#3,2:84\n*S KotlinDebug\n*F\n+ 1 OBSClientHandler.kt\napp/termora/plugins/obs/OBSClientHandler\n*L\n62#1:82,2\n74#1:84,2\n*E\n"})
public final class OBSClientHandler
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IObsCredentialsProvider cred;
    @NotNull
    private final Proxy proxy;
    @NotNull
    private final List<ObsBucket> buckets;
    @NotNull
    private final Map<String, ObsClient> clients;
    @NotNull
    private final AtomicBoolean closed;

    public OBSClientHandler(@NotNull IObsCredentialsProvider cred, @NotNull Proxy proxy, @NotNull List<? extends ObsBucket> buckets) {
        Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
        this.cred = cred;
        this.proxy = proxy;
        this.buckets = buckets;
        this.clients = new LinkedHashMap();
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final List<ObsBucket> getBuckets() {
        return this.buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ObsClient getClientForBucket(@NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        if (this.closed.get()) {
            throw new IllegalStateException("Client already closed");
        }
        OBSClientHandler oBSClientHandler = this;
        synchronized (oBSClientHandler) {
            ObsBucket bucket2;
            block7: {
                Object element$iv2;
                block6: {
                    boolean bl = false;
                    Iterable $this$first$iv = this.buckets;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ObsBucket it = (ObsBucket)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getBucketName(), (Object)bucket)) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                bucket2 = (ObsBucket)element$iv2;
                if (!this.clients.containsKey(bucket2.getLocation())) break block7;
                ObsClient obsClient = (ObsClient)MapsKt.getValue(this.clients, (Object)bucket2.getLocation());
                return obsClient;
            }
            this.clients.put(bucket2.getLocation(), Companion.createOBSClient(this.cred, "https://obs." + bucket2.getLocation() + ".myhuaweicloud.com", this.proxy));
            ObsClient obsClient = (ObsClient)MapsKt.getValue(this.clients, (Object)bucket2.getLocation());
            return obsClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            OBSClientHandler oBSClientHandler = this;
            synchronized (oBSClientHandler) {
                boolean bl = false;
                Map<String, ObsClient> $this$forEach$iv = this.clients;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ObsClient>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ObsClient> element$iv;
                    Map.Entry<String, ObsClient> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    IOUtils.closeQuietly((Closeable)((Closeable)it.getValue()));
                }
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/obs/OBSClientHandler$Companion;", "", "<init>", "()V", "createOBSClient", "Lcom/obs/services/ObsClient;", "cred", "Lcom/obs/services/IObsCredentialsProvider;", "endpoint", "", "proxy", "Lapp/termora/Proxy;", "obs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObsClient createOBSClient(@NotNull IObsCredentialsProvider cred, @NotNull String endpoint, @NotNull Proxy proxy) {
            Object newEndpoint;
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            ObsConfiguration configuration = new ObsConfiguration();
            if (proxy.getType() == ProxyType.HTTP) {
                if (proxy.getAuthenticationType() == AuthenticationType.Password) {
                    configuration.setHttpProxy(proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword());
                } else {
                    configuration.setHttpProxy(proxy.getHost(), proxy.getPort(), null, null);
                }
            }
            if (!StringsKt.startsWith$default((String)(newEndpoint = endpoint), (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)newEndpoint, (String)"https://", (boolean)false, (int)2, null)) {
                newEndpoint = "https://" + endpoint;
            }
            configuration.setEndPoint((String)newEndpoint);
            ObsClient obsClient = new ObsClient(cred, configuration);
            return obsClient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

