/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.oss;

import app.termora.AuthenticationType;
import app.termora.Proxy;
import app.termora.ProxyType;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.model.Bucket;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapp/termora/plugins/oss/OSSClientHandler;", "Ljava/io/Closeable;", "endpoint", "", "cred", "Lcom/aliyun/oss/common/auth/CredentialsProvider;", "proxy", "Lapp/termora/Proxy;", "buckets", "", "Lcom/aliyun/oss/model/Bucket;", "<init>", "(Ljava/lang/String;Lcom/aliyun/oss/common/auth/CredentialsProvider;Lapp/termora/Proxy;Ljava/util/List;)V", "getBuckets", "()Ljava/util/List;", "clients", "", "Lcom/aliyun/oss/OSS;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClientForBucket", "bucket", "close", "", "Companion", "oss"})
@SourceDebugExtension(value={"SMAP\nOSSClientHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSSClientHandler.kt\napp/termora/plugins/oss/OSSClientHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,88:1\n230#2,2:89\n216#3,2:91\n*S KotlinDebug\n*F\n+ 1 OSSClientHandler.kt\napp/termora/plugins/oss/OSSClientHandler\n*L\n69#1:89,2\n81#1:91,2\n*E\n"})
public final class OSSClientHandler
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String endpoint;
    @NotNull
    private final CredentialsProvider cred;
    @NotNull
    private final Proxy proxy;
    @NotNull
    private final List<Bucket> buckets;
    @NotNull
    private final Map<String, OSS> clients;
    @NotNull
    private final AtomicBoolean closed;

    public OSSClientHandler(@NotNull String endpoint, @NotNull CredentialsProvider cred, @NotNull Proxy proxy, @NotNull List<? extends Bucket> buckets) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
        this.endpoint = endpoint;
        this.cred = cred;
        this.proxy = proxy;
        this.buckets = buckets;
        this.clients = new LinkedHashMap();
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final List<Bucket> getBuckets() {
        return this.buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final OSS getClientForBucket(@NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        if (this.closed.get()) {
            throw new IllegalStateException("Client already closed");
        }
        OSSClientHandler oSSClientHandler = this;
        synchronized (oSSClientHandler) {
            Bucket bucket2;
            block7: {
                Object element$iv2;
                block6: {
                    boolean bl = false;
                    Iterable $this$first$iv = this.buckets;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        Bucket it = (Bucket)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)bucket)) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                bucket2 = (Bucket)element$iv2;
                if (!this.clients.containsKey(bucket2.getLocation())) break block7;
                OSS oSS = (OSS)MapsKt.getValue(this.clients, (Object)bucket2.getLocation());
                return oSS;
            }
            Map<String, OSS> map = this.clients;
            String string = bucket2.getLocation();
            String string2 = bucket2.getExtranetEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtranetEndpoint(...)");
            String string3 = bucket2.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocation(...)");
            OSS oSS = Companion.createCOSClient(this.cred, string2, string3, this.proxy);
            map.put(string, oSS);
            OSS oSS2 = (OSS)MapsKt.getValue(this.clients, (Object)bucket2.getLocation());
            return oSS2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            OSSClientHandler oSSClientHandler = this;
            synchronized (oSSClientHandler) {
                boolean bl = false;
                Map<String, OSS> $this$forEach$iv = this.clients;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, OSS>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, OSS> element$iv;
                    Map.Entry<String, OSS> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    it.getValue().shutdown();
                }
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lapp/termora/plugins/oss/OSSClientHandler$Companion;", "", "<init>", "()V", "createCOSClient", "Lcom/aliyun/oss/OSS;", "cred", "Lcom/aliyun/oss/common/auth/CredentialsProvider;", "endpoint", "", "region", "proxy", "Lapp/termora/Proxy;", "oss"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OSS createCOSClient(@NotNull CredentialsProvider cred, @NotNull String endpoint, @NotNull String region, @NotNull Proxy proxy) {
            Object newEndpoint;
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            ClientBuilderConfiguration configuration = new ClientBuilderConfiguration();
            if (proxy.getType() == ProxyType.HTTP) {
                configuration.setProxyHost(proxy.getHost());
                configuration.setProxyPort(proxy.getPort());
                if (proxy.getAuthenticationType() == AuthenticationType.Password) {
                    configuration.setProxyPassword(proxy.getPassword());
                    configuration.setProxyUsername(proxy.getUsername());
                }
            }
            if (!StringsKt.startsWith$default((String)(newEndpoint = endpoint), (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)newEndpoint, (String)"https://", (boolean)false, (int)2, null)) {
                newEndpoint = "https://" + endpoint;
            }
            OSSClientBuilder.OSSClientBuilderImpl builder = OSSClientBuilder.create().endpoint((String)newEndpoint).credentialsProvider(cred);
            if (!StringsKt.isBlank((CharSequence)region)) {
                builder.region(region);
            }
            OSS oSS = builder.clientConfiguration((ClientConfiguration)configuration).build();
            Intrinsics.checkNotNullExpressionValue((Object)oSS, (String)"build(...)");
            return oSS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

