/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.oss;

import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.plugins.oss.OSSClientHandler;
import app.termora.plugins.oss.OSSFileSystem;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import com.aliyun.oss.OSS;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.CredentialsProviderFactory;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/oss/OSSProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "getProtocol", "", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "oss"})
public final class OSSProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<OSSProtocolProvider> instance$delegate = LazyKt.lazy(OSSProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "OSS";

    private OSSProtocolProvider() {
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getAliyun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Host host = requester.getHost();
        String accessKeyId = host.getUsername();
        String secretAccessKey = host.getAuthentication().getPassword();
        DefaultCredentialProvider credential = CredentialsProviderFactory.newDefaultCredentialProvider((String)accessKeyId, (String)secretAccessKey);
        Intrinsics.checkNotNull((Object)credential);
        OSS oss = OSSClientHandler.Companion.createCOSClient((CredentialsProvider)credential, "oss-cn-hangzhou.aliyuncs.com", "", host.getProxy());
        List buckets = null;
        try {
            List list = oss.listBuckets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listBuckets(...)");
            buckets = list;
        }
        finally {
            oss.shutdown();
        }
        String defaultPath = host.getOptions().getSftpDefaultDirectory();
        OSSFileSystem fs = new OSSFileSystem(new OSSClientHandler(host.getHost(), (CredentialsProvider)credential, host.getProxy(), buckets));
        FileSystem fileSystem = (FileSystem)((Object)fs);
        Path path = fs.getPath(defaultPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new PathHandler(fileSystem, path);
    }

    public boolean isTransfer() {
        return super.isTransfer();
    }

    public boolean isTransient() {
        return super.isTransient();
    }

    public int ordered() {
        return super.ordered();
    }

    private static final OSSProtocolProvider instance_delegate$lambda$0() {
        return new OSSProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/oss/OSSProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/oss/OSSProtocolProvider;", "getInstance", "()Lapp/termora/plugins/oss/OSSProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "oss"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OSSProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (OSSProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

