/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.fife.rsta.ac.java.PackageMapNode;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class Jdk9LibraryInfo
extends LibraryInfo {
    private File[] jmodFiles;
    private JarFile[] bulkCreateJmods;

    public Jdk9LibraryInfo(File[] jmodFiles) {
        this(jmodFiles, null);
    }

    public Jdk9LibraryInfo(File[] jmodFiles, SourceLocation sourceLoc) {
        this.setJmodFiles(jmodFiles);
        this.setSourceLocation(sourceLoc);
    }

    @Override
    public void bulkClassFileCreationEnd() {
        for (JarFile bulkCreateJar : this.bulkCreateJmods) {
            try {
                bulkCreateJar.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.bulkCreateJmods = null;
    }

    @Override
    public void bulkClassFileCreationStart() {
        this.bulkCreateJmods = new JarFile[this.jmodFiles.length];
        for (int i = 0; i < this.jmodFiles.length; ++i) {
            File jarFile = this.jmodFiles[i];
            try {
                this.bulkCreateJmods[i] = new JarFile(jarFile);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public int compareTo(LibraryInfo info) {
        if (info == this) {
            return 0;
        }
        int result = -1;
        if (info instanceof Jdk9LibraryInfo) {
            result = this == info ? 0 : -1;
        }
        return result;
    }

    @Override
    public ClassFile createClassFile(String entryName) throws IOException {
        for (File jarFile : this.jmodFiles) {
            try (JarFile jar = new JarFile(jarFile);){
                ClassFile c = Jdk9LibraryInfo.createClassFileImpl(jar, entryName);
                if (c == null) continue;
                ClassFile classFile = c;
                return classFile;
            }
        }
        return null;
    }

    @Override
    public ClassFile createClassFileBulk(String entryName) throws IOException {
        for (JarFile bulkCreateJar : this.bulkCreateJmods) {
            ClassFile c = Jdk9LibraryInfo.createClassFileImpl(bulkCreateJar, entryName);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassFile createClassFileImpl(JarFile jar, String entryName) throws IOException {
        ClassFile cf;
        JarEntry entry = (JarEntry)jar.getEntry("classes/" + entryName);
        if (entry == null) {
            return null;
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(jar.getInputStream(entry)));){
            cf = new ClassFile(in);
        }
        return cf;
    }

    @Override
    public PackageMapNode createPackageMap() throws IOException {
        PackageMapNode root = new PackageMapNode();
        for (File jarFile : this.jmodFiles) {
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith("classes/") || !(entryName = entryName.substring(8)).endsWith(".class")) continue;
                    root.add(entryName);
                }
            }
        }
        return root;
    }

    public File getJreHome() {
        File firstJmodFile;
        if (this.jmodFiles != null && this.jmodFiles.length > 0 && (firstJmodFile = this.jmodFiles[0]) != null) {
            return firstJmodFile.getParentFile().getParentFile();
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public String getLocationAsString() {
        return "";
    }

    @Override
    public int hashCodeImpl() {
        int h = 0;
        for (File jarFile : this.jmodFiles) {
            h += jarFile.hashCode();
        }
        return h;
    }

    private void setJmodFiles(File[] jmodFiles) {
        for (File jarFile : jmodFiles) {
            if (jarFile != null && jarFile.exists()) continue;
            String name = jarFile == null ? "null" : jarFile.getAbsolutePath();
            throw new IllegalArgumentException("Jar does not exist: " + name);
        }
        this.jmodFiles = jmodFiles;
    }

    public String toString() {
        return "[JarLibraryInfo: jars=" + this.jmodFiles.toString() + "; source=" + this.getSourceLocation() + "]";
    }
}

