/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.smb;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.FixedLengthTextArea;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.Options;
import app.termora.OptionsPane;
import app.termora.OutlineComboBox;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.PortSpinner;
import app.termora.plugins.smb.SMBHostOptionsPane;
import app.termora.plugins.smb.SMBI18n;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/termora/plugins/smb/SMBHostOptionsPane;", "Lapp/termora/OptionsPane;", "<init>", "()V", "generalOption", "Lapp/termora/plugins/smb/SMBHostOptionsPane$GeneralOption;", "sftpOption", "Lapp/termora/plugins/smb/SMBHostOptionsPane$SFTPOption;", "getHost", "Lapp/termora/Host;", "setHost", "", "host", "validateFields", "", "validateField", "textField", "Ljavax/swing/JTextField;", "setOutlineError", "Ljavax/swing/JComponent;", "GeneralOption", "SFTPOption", "smb"})
public final class SMBHostOptionsPane
extends OptionsPane {
    @NotNull
    private final GeneralOption generalOption = new GeneralOption();
    @NotNull
    private final SFTPOption sftpOption = new SFTPOption();

    public SMBHostOptionsPane() {
        this.addOption(this.generalOption);
        this.addOption(this.sftpOption);
    }

    @NotNull
    public final Host getHost() {
        String name = this.generalOption.getNameTextField().getText();
        String protocol = "SMB";
        String host = this.generalOption.getHostTextField().getText();
        Object object = this.generalOption.getPortTextField().getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int port = (Integer)object;
        Authentication authentication = Authentication.Companion.getNo();
        AuthenticationType authenticationType = AuthenticationType.Password;
        char[] cArray = this.generalOption.getPasswordTextField().getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        char[] cArray2 = cArray;
        authentication = authentication.copy(authenticationType, new String(cArray2));
        Options options = Options.Companion.getDefault();
        String string = this.sftpOption.getDefaultDirectoryField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Object object2 = new Pair[]{TuplesKt.to((Object)"smb.share", (Object)this.generalOption.getShareTextField().getText())};
        Options options2 = Options.copy$default((Options)options, null, null, null, null, null, (int)0, null, (String)string, (boolean)false, null, null, (Map)MapsKt.mutableMapOf((Pair[])object2), (int)1919, null);
        Intrinsics.checkNotNull((Object)name);
        object2 = name;
        Intrinsics.checkNotNull((Object)host);
        String string2 = host;
        Object object3 = this.generalOption.getUsernameTextField().getSelectedItem();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String string3 = (String)object3;
        Authentication authentication2 = authentication;
        long l = System.currentTimeMillis();
        String string4 = this.generalOption.getRemarkTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String string5 = string4;
        return new Host(null, (String)object2, protocol, string2, port, string3, string5, authentication2, null, options2, null, l, null, null, null, null, false, 0L, 0L, 521473, null);
    }

    public final void setHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.generalOption.getNameTextField().setText(host.getName());
        this.generalOption.getUsernameTextField().setSelectedItem((Object)host.getUsername());
        this.generalOption.getHostTextField().setText(host.getHost());
        this.generalOption.getPortTextField().setValue((Object)host.getPort());
        this.generalOption.getRemarkTextArea().setText(host.getRemark());
        this.generalOption.getPasswordTextField().setText(host.getAuthentication().getPassword());
        OutlineTextField outlineTextField = this.generalOption.getShareTextField();
        String string = (String)host.getOptions().getExtras().get("smb.share");
        if (string == null) {
            string = "";
        }
        outlineTextField.setText(string);
        this.sftpOption.getDefaultDirectoryField().setText(host.getOptions().getSftpDefaultDirectory());
    }

    public final boolean validateFields() {
        if (this.validateField((JTextField)this.generalOption.getNameTextField()) || this.validateField((JTextField)this.generalOption.getHostTextField()) || this.validateField((JTextField)this.generalOption.getShareTextField())) {
            return false;
        }
        String username = (String)this.generalOption.getUsernameTextField().getSelectedItem();
        CharSequence charSequence = username;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.setOutlineError((JComponent)this.generalOption.getUsernameTextField());
            return false;
        }
        return true;
    }

    private final boolean validateField(JTextField textField) {
        if (textField.isEnabled()) {
            String string = textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setOutlineError(textField);
                return true;
            }
        }
        return false;
    }

    private final void setOutlineError(JComponent textField) {
        this.selectOptionJComponent(textField);
        textField.putClientProperty("JComponent.outline", "error");
        textField.requestFocusInWindow();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lapp/termora/plugins/smb/SMBHostOptionsPane$GeneralOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugins/smb/SMBHostOptionsPane;)V", "portTextField", "Lapp/termora/PortSpinner;", "getPortTextField", "()Lapp/termora/PortSpinner;", "nameTextField", "Lapp/termora/OutlineTextField;", "getNameTextField", "()Lapp/termora/OutlineTextField;", "shareTextField", "getShareTextField", "usernameTextField", "Lapp/termora/OutlineComboBox;", "", "getUsernameTextField", "()Lapp/termora/OutlineComboBox;", "hostTextField", "getHostTextField", "passwordTextField", "Lapp/termora/OutlinePasswordField;", "getPasswordTextField", "()Lapp/termora/OutlinePasswordField;", "remarkTextArea", "Lapp/termora/FixedLengthTextArea;", "getRemarkTextArea", "()Lapp/termora/FixedLengthTextArea;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "smb"})
    @SourceDebugExtension(value={"SMAP\nSMBHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMBHostOptionsPane.kt\napp/termora/plugins/smb/SMBHostOptionsPane$GeneralOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
    private final class GeneralOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final PortSpinner portTextField;
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField shareTextField;
        @NotNull
        private final OutlineComboBox<String> usernameTextField;
        @NotNull
        private final OutlineTextField hostTextField;
        @NotNull
        private final OutlinePasswordField passwordTextField;
        @NotNull
        private final FixedLengthTextArea remarkTextArea;

        public GeneralOption() {
            super(new BorderLayout());
            this.portTextField = new PortSpinner(445);
            this.nameTextField = new OutlineTextField(128);
            this.shareTextField = new OutlineTextField(256);
            this.usernameTextField = new OutlineComboBox();
            this.hostTextField = new OutlineTextField(255);
            this.passwordTextField = new OutlinePasswordField(255, false, 2, null);
            this.remarkTextArea = new FixedLengthTextArea(512);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final PortSpinner getPortTextField() {
            return this.portTextField;
        }

        @NotNull
        public final OutlineTextField getNameTextField() {
            return this.nameTextField;
        }

        @NotNull
        public final OutlineTextField getShareTextField() {
            return this.shareTextField;
        }

        @NotNull
        public final OutlineComboBox<String> getUsernameTextField() {
            return this.usernameTextField;
        }

        @NotNull
        public final OutlineTextField getHostTextField() {
            return this.hostTextField;
        }

        @NotNull
        public final OutlinePasswordField getPasswordTextField() {
            return this.passwordTextField;
        }

        @NotNull
        public final FixedLengthTextArea getRemarkTextArea() {
            return this.remarkTextArea;
        }

        private final void initView() {
            this.usernameTextField.setEditable(true);
            this.usernameTextField.addItem((Object)"Guest");
            this.usernameTextField.addItem((Object)"Anonymous");
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final void initEvents() {
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> initEvents.1.componentResized$lambda$0(this.this$0));
                    this.this$0.removeComponentListener(this);
                }

                private static final void componentResized$lambda$0(GeneralOption this$0) {
                    this$0.getNameTextField().requestFocusInWindow();
                }
            });
        }

        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)Icons.INSTANCE.getSettings();
        }

        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.general");
        }

        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent getCenterComponent() {
            void $this$getCenterComponent_u24lambda_u245;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, pref, 7dlu, default", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            this.remarkTextArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.remarkTextArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
            this.remarkTextArea.setRows(8);
            this.remarkTextArea.setLineWrap(true);
            this.remarkTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = object = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.new-host.general.name") + ":", new Object[0]).xy(1, rows).add((Component)this.nameTextField).xyw(3, rows, 5);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.host") + ":", new Object[0]).xy(1, rows += step).add((Component)this.hostTextField).xy(3, rows).add(I18n.INSTANCE.getString("termora.new-host.general.port") + ":", new Object[0]).xy(5, rows).add((Component)this.portTextField).xy(7, rows);
            boolean bl2 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u242 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.username") + ":", new Object[0]).xy(1, rows += step).add((Component)this.usernameTextField).xyw(3, rows, 5);
            boolean bl3 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u243 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.password") + ":", new Object[0]).xy(1, rows += step).add((Component)this.passwordTextField).xyw(3, rows, 5);
            boolean bl4 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u244 = object = object.add(SMBI18n.INSTANCE.getString("termora.plugins.smb.share") + ":", new Object[0]).xy(1, rows += step).add((Component)this.shareTextField).xyw(3, rows, 5);
            boolean bl5 = false;
            FormBuilder formBuilder = object.add(I18n.INSTANCE.getString("termora.new-host.general.remark") + ":", new Object[0]).xy(1, rows += step);
            $this$getCenterComponent_u24lambda_u244 = object = new JScrollPane((Component)this.remarkTextArea);
            FormBuilder formBuilder2 = formBuilder;
            boolean bl6 = false;
            $this$getCenterComponent_u24lambda_u245.setBorder((Border)new FlatTextBorder());
            Object $this$getCenterComponent_u24lambda_u246 = object = formBuilder2.add((Component)object).xyw(3, rows, 5);
            boolean bl7 = false;
            rows += step;
            JPanel panel = object.build();
            Intrinsics.checkNotNull((Object)panel);
            return panel;
        }

        @NotNull
        public String getIdentifier() {
            return super.getIdentifier();
        }

        @NotNull
        public OptionsPane.Anchor getAnchor() {
            return super.getAnchor();
        }

        public void onSelected() {
            super.onSelected();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lapp/termora/plugins/smb/SMBHostOptionsPane$SFTPOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugins/smb/SMBHostOptionsPane;)V", "defaultDirectoryField", "Lapp/termora/OutlineTextField;", "getDefaultDirectoryField", "()Lapp/termora/OutlineTextField;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "smb"})
    @SourceDebugExtension(value={"SMAP\nSMBHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMBHostOptionsPane.kt\napp/termora/plugins/smb/SMBHostOptionsPane$SFTPOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
    private final class SFTPOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final OutlineTextField defaultDirectoryField;

        public SFTPOption() {
            super(new BorderLayout());
            this.defaultDirectoryField = new OutlineTextField(255);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final OutlineTextField getDefaultDirectoryField() {
            return this.defaultDirectoryField;
        }

        private final void initView() {
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final void initEvents() {
        }

        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)Icons.INSTANCE.getFolder();
        }

        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.transport.sftp");
        }

        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private final JComponent getCenterComponent() {
            FormBuilder formBuilder;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = formBuilder = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.settings.sftp.default-directory") + ":", new Object[0]).xy(1, rows).add((Component)this.defaultDirectoryField).xy(3, rows);
            boolean bl = false;
            rows += step;
            JPanel panel = formBuilder.build();
            Intrinsics.checkNotNull((Object)panel);
            return panel;
        }

        @NotNull
        public String getIdentifier() {
            return super.getIdentifier();
        }

        @NotNull
        public OptionsPane.Anchor getAnchor() {
            return super.getAnchor();
        }

        public void onSelected() {
            super.onSelected();
        }
    }
}

