/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.smb;

import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.plugins.smb.SMBFileSystem;
import app.termora.plugins.smb.SMBPathHandler;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.Share;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/smb/SMBProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "getProtocol", "", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "smb"})
public final class SMBProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<SMBProtocolProvider> instance$delegate = LazyKt.lazy(SMBProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "SMB";

    private SMBProtocolProvider() {
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getWindows7();
    }

    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        String sftpDefaultDirectory;
        String string;
        Session session;
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        SMBClient client = new SMBClient();
        Host host = requester.getHost();
        Connection connection = client.connect(host.getHost(), host.getPort());
        String string2 = host.getUsername();
        if (Intrinsics.areEqual((Object)string2, (Object)"Guest")) {
            v0 = connection.authenticate(AuthenticationContext.guest());
        } else if (Intrinsics.areEqual((Object)string2, (Object)"Anonymous")) {
            v0 = connection.authenticate(AuthenticationContext.anonymous());
        } else {
            String string3 = host.getUsername();
            char[] cArray = host.getAuthentication().getPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            v0 = session = connection.authenticate(new AuthenticationContext(string3, cArray, null));
        }
        if ((string = (String)host.getOptions().getExtras().get("smb.share")) == null) {
            string = "";
        }
        Share share = session.connectShare(string);
        Intrinsics.checkNotNull((Object)share, (String)"null cannot be cast to non-null type com.hierynomus.smbj.share.DiskShare");
        DiskShare share2 = (DiskShare)share;
        String string4 = sftpDefaultDirectory = StringUtils.defaultString((String)host.getOptions().getSftpDefaultDirectory());
        Intrinsics.checkNotNull((Object)string4);
        sftpDefaultDirectory = !StringsKt.isBlank((CharSequence)string4) ? FilenameUtils.separatorsToUnix((String)sftpDefaultDirectory) : "/";
        Intrinsics.checkNotNull((Object)session);
        SMBFileSystem fs = new SMBFileSystem(share2, session);
        FileSystem fileSystem = (FileSystem)((Object)fs);
        Path path = fs.getPath(sftpDefaultDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new SMBPathHandler(client, session, fileSystem, path);
    }

    public boolean isTransfer() {
        return super.isTransfer();
    }

    public boolean isTransient() {
        return super.isTransient();
    }

    public int ordered() {
        return super.ordered();
    }

    private static final SMBProtocolProvider instance_delegate$lambda$0() {
        return new SMBProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/smb/SMBProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/smb/SMBProtocolProvider;", "getInstance", "()Lapp/termora/plugins/smb/SMBProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "smb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SMBProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (SMBProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

