/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.ftp;

import app.termora.transfer.s3.S3FileAttributes;
import app.termora.transfer.s3.S3FileSystemProvider;
import app.termora.transfer.s3.S3Path;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J1\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\"\u0006\u0012\u0002\b\u00030\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ9\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010#0\u001c\"\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0016J)\u0010(\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\u001c\"\u00020*H\u0016\u00a2\u0006\u0002\u0010+J(\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H-0/H\u0082\b\u00a2\u0006\u0002\u00100R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lapp/termora/plugins/ftp/FTPSystemProvider;", "Lapp/termora/transfer/s3/S3FileSystemProvider;", "pool", "Lorg/apache/commons/pool2/impl/GenericObjectPool;", "Lorg/apache/commons/net/ftp/FTPClient;", "<init>", "(Lorg/apache/commons/pool2/impl/GenericObjectPool;)V", "getScheme", "", "getOutputStream", "Ljava/io/OutputStream;", "path", "Lapp/termora/transfer/s3/S3Path;", "getInputStream", "Ljava/io/InputStream;", "createStreamer", "fetchChildren", "", "ftpPermissionsToPosix", "", "Ljava/nio/file/attribute/PosixFilePermission;", "file", "Lorg/apache/commons/net/ftp/FTPFile;", "createDirectory", "", "dir", "Ljava/nio/file/Path;", "attrs", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "move", "source", "target", "options", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "delete", "isDirectory", "", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Lapp/termora/transfer/s3/S3Path;[Ljava/nio/file/AccessMode;)V", "withFtpClient", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ftp"})
@SourceDebugExtension(value={"SMAP\nFTPSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FTPSystemProvider.kt\napp/termora/plugins/ftp/FTPSystemProvider\n*L\n1#1,158:1\n151#1,6:159\n151#1,6:165\n151#1,6:171\n151#1,6:177\n151#1,6:183\n*S KotlinDebug\n*F\n+ 1 FTPSystemProvider.kt\napp/termora/plugins/ftp/FTPSystemProvider\n*L\n69#1:159,6\n117#1:165,6\n122#1:171,6\n129#1:177,6\n139#1:183,6\n*E\n"})
public final class FTPSystemProvider
extends S3FileSystemProvider {
    @NotNull
    private final GenericObjectPool<FTPClient> pool;

    public FTPSystemProvider(@NotNull GenericObjectPool<FTPClient> pool) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        this.pool = pool;
    }

    @Nullable
    public String getScheme() {
        return "ftp";
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.createStreamer(path);
    }

    @NotNull
    public InputStream getInputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FTPClient ftp = (FTPClient)this.pool.borrowObject();
        InputStream fs = ftp.retrieveFileStream(((Object)((Path)path).toAbsolutePath()).toString());
        return new InputStream(fs, ftp, this){
            final /* synthetic */ InputStream $fs;
            final /* synthetic */ FTPClient $ftp;
            final /* synthetic */ FTPSystemProvider this$0;
            {
                this.$fs = $fs;
                this.$ftp = $ftp;
                this.this$0 = $receiver;
            }

            public int read() {
                return this.$fs.read();
            }

            public void close() {
                IOUtils.closeQuietly((InputStream)this.$fs);
                this.$ftp.completePendingCommand();
                FTPSystemProvider.access$getPool$p(this.this$0).returnObject((Object)this.$ftp);
            }
        };
    }

    private final OutputStream createStreamer(S3Path path) {
        FTPClient ftp = (FTPClient)this.pool.borrowObject();
        OutputStream os = ftp.storeFileStream(((Object)((Path)path).toAbsolutePath()).toString());
        return new OutputStream(os, ftp, this){
            final /* synthetic */ OutputStream $os;
            final /* synthetic */ FTPClient $ftp;
            final /* synthetic */ FTPSystemProvider this$0;
            {
                this.$os = $os;
                this.$ftp = $ftp;
                this.this$0 = $receiver;
            }

            public void write(int b) {
                this.$os.write(b);
            }

            public void close() {
                IOUtils.closeQuietly((OutputStream)this.$os);
                this.$ftp.completePendingCommand();
                FTPSystemProvider.access$getPool$p(this.this$0).returnObject((Object)this.$ftp);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<S3Path> fetchChildren(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List paths = new ArrayList();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new NoSuchFileException(((Object)((Path)path).toAbsolutePath()).toString());
        }
        FTPSystemProvider this_$iv = this;
        boolean $i$f$withFtpClient = false;
        FTPClient client$iv = (FTPClient)this_$iv.pool.borrowObject();
        try {
            Intrinsics.checkNotNull((Object)client$iv);
            FTPClient it = client$iv;
            boolean bl = false;
            Object[] files = it.listFiles(((Object)((Path)path).toAbsolutePath()).toString());
            Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
            while (iterator.hasNext()) {
                FTPFile file = (FTPFile)iterator.next();
                S3Path p = (S3Path)path.resolve(file.getName());
                S3FileAttributes s3FileAttributes = p.getAttributes();
                boolean bl2 = file.isDirectory();
                boolean bl3 = file.isFile();
                long l = file.getSize();
                long l2 = file.getTimestamp().getTimeInMillis();
                p.setAttributes(S3FileAttributes.copy$default((S3FileAttributes)s3FileAttributes, (long)l2, (long)0L, (long)0L, (boolean)bl3, (boolean)bl2, (boolean)false, (boolean)false, (long)l, (int)102, null));
                S3FileAttributes s3FileAttributes2 = p.getAttributes();
                Intrinsics.checkNotNull((Object)file);
                s3FileAttributes2.setPermissions(this.ftpPermissionsToPosix(file));
                Intrinsics.checkNotNull((Object)p);
                paths.add(p);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.pool.returnObject((Object)client$iv);
        }
        return paths;
    }

    private final Set<PosixFilePermission> ftpPermissionsToPosix(FTPFile file) {
        Set perms = new LinkedHashSet();
        if (file.hasPermission(0, 0)) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if (file.hasPermission(0, 1)) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if (file.hasPermission(0, 2)) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (file.hasPermission(1, 0)) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if (file.hasPermission(1, 1)) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if (file.hasPermission(1, 2)) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (file.hasPermission(2, 0)) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if (file.hasPermission(2, 1)) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (file.hasPermission(2, 2)) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        FTPSystemProvider this_$iv = this;
        boolean $i$f$withFtpClient = false;
        FTPClient client$iv = (FTPClient)this_$iv.pool.borrowObject();
        try {
            Intrinsics.checkNotNull((Object)client$iv);
            FTPClient it = client$iv;
            boolean bl = false;
            int n = it.mkd(((Object)dir.toAbsolutePath()).toString());
        }
        finally {
            this_$iv.pool.returnObject((Object)client$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(@Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (source != null && target != null) {
            FTPSystemProvider this_$iv = this;
            boolean $i$f$withFtpClient = false;
            FTPClient client$iv = (FTPClient)this_$iv.pool.borrowObject();
            try {
                Intrinsics.checkNotNull((Object)client$iv);
                FTPClient it = client$iv;
                boolean bl = false;
                boolean bl2 = it.rename(((Object)source.toAbsolutePath()).toString(), ((Object)target.toAbsolutePath()).toString());
            }
            finally {
                this_$iv.pool.returnObject((Object)client$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@NotNull S3Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FTPSystemProvider this_$iv = this;
        boolean $i$f$withFtpClient = false;
        FTPClient client$iv = (FTPClient)this_$iv.pool.borrowObject();
        try {
            Intrinsics.checkNotNull((Object)client$iv);
            FTPClient it = client$iv;
            boolean bl = false;
            Constable constable = isDirectory ? (Constable)Integer.valueOf(it.rmd(((Object)((Path)path).toAbsolutePath()).toString())) : (Constable)Boolean.valueOf(it.deleteFile(((Object)((Path)path).toAbsolutePath()).toString()));
        }
        finally {
            this_$iv.pool.returnObject((Object)client$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAccess(@NotNull S3Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        FTPSystemProvider this_$iv = this;
        boolean $i$f$withFtpClient = false;
        FTPClient client$iv = (FTPClient)this_$iv.pool.borrowObject();
        try {
            Intrinsics.checkNotNull((Object)client$iv);
            FTPClient it = client$iv;
            boolean bl = false;
            if (it.cwd(((Object)((Path)path).toAbsolutePath()).toString()) == 250) {
                return;
            }
            FTPFile[] fTPFileArray = it.listFiles(((Object)((Path)path).toAbsolutePath()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)fTPFileArray, (String)"listFiles(...)");
            if (!(((Object[])fTPFileArray).length == 0)) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.pool.returnObject((Object)client$iv);
        }
        throw new NoSuchFileException(((Object)((Path)path).toAbsolutePath()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withFtpClient(Function1<? super FTPClient, ? extends T> block) {
        Object object;
        boolean $i$f$withFtpClient = false;
        FTPClient client = (FTPClient)this.pool.borrowObject();
        try {
            Intrinsics.checkNotNull((Object)client);
            object = block.invoke((Object)client);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.pool.returnObject((Object)client);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public static final /* synthetic */ GenericObjectPool access$getPool$p(FTPSystemProvider $this) {
        return $this.pool;
    }
}

