/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.smb;

import app.termora.transfer.s3.S3FileAttributes;
import app.termora.transfer.s3.S3FileSystem;
import app.termora.transfer.s3.S3FileSystemProvider;
import app.termora.transfer.s3.S3Path;
import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessMode;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J1\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u001a\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017\"\u0006\u0012\u0002\b\u00030\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J)\u0010\u001d\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u0017\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/plugins/smb/SMBFileSystemProvider;", "Lapp/termora/transfer/s3/S3FileSystemProvider;", "share", "Lcom/hierynomus/smbj/share/DiskShare;", "session", "Lcom/hierynomus/smbj/session/Session;", "<init>", "(Lcom/hierynomus/smbj/share/DiskShare;Lcom/hierynomus/smbj/session/Session;)V", "getScheme", "", "getOutputStream", "Ljava/io/OutputStream;", "path", "Lapp/termora/transfer/s3/S3Path;", "getInputStream", "Ljava/io/InputStream;", "fetchChildren", "", "createDirectory", "", "dir", "Ljava/nio/file/Path;", "attrs", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "isDirectory", "", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Lapp/termora/transfer/s3/S3Path;[Ljava/nio/file/AccessMode;)V", "smb"})
public final class SMBFileSystemProvider
extends S3FileSystemProvider {
    @NotNull
    private final DiskShare share;
    @NotNull
    private final Session session;

    public SMBFileSystemProvider(@NotNull DiskShare share, @NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)share, (String)"share");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.share = share;
        this.session = session;
    }

    @Nullable
    public String getScheme() {
        return "smb";
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = this.share.openFile(((Object)((Path)path).toAbsolutePath()).toString(), SetsKt.setOf((Object)AccessMask.GENERIC_WRITE), SetsKt.setOf((Object)FileAttributes.FILE_ATTRIBUTE_NORMAL), SetsKt.setOf((Object)SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OVERWRITE_IF, SetsKt.setOf((Object)SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));
        OutputStream os = file.getOutputStream();
        return new OutputStream(os, file){
            final /* synthetic */ OutputStream $os;
            final /* synthetic */ File $file;
            {
                this.$os = $os;
                this.$file = $file;
            }

            public void write(int b) {
                this.$os.write(b);
            }

            public void close() {
                IOUtils.closeQuietly((OutputStream)this.$os);
                this.$file.closeNoWait();
            }
        };
    }

    @NotNull
    public InputStream getInputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = this.share.openFile(((Object)((Path)path).toAbsolutePath()).toString(), SetsKt.setOf((Object)AccessMask.GENERIC_READ), SetsKt.setOf((Object)FileAttributes.FILE_ATTRIBUTE_NORMAL), SetsKt.setOf((Object)SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, SetsKt.setOf((Object)SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));
        InputStream input = file.getInputStream();
        return new InputStream(input, file){
            final /* synthetic */ InputStream $input;
            final /* synthetic */ File $file;
            {
                this.$input = $input;
                this.$file = $file;
            }

            public int read() {
                return this.$input.read();
            }

            public void close() {
                IOUtils.closeQuietly((InputStream)this.$input);
                this.$file.closeNoWait();
            }
        };
    }

    @NotNull
    public List<S3Path> fetchChildren(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List paths = new ArrayList();
        String absolutePath = FilenameUtils.separatorsToUnix((String)((Object)((Path)path).toAbsolutePath()).toString());
        for (FileIdBothDirectoryInformation information : this.share.list(Intrinsics.areEqual((Object)absolutePath, (Object)((S3FileSystem)path.getFileSystem()).getSeparator()) ? "" : absolutePath)) {
            if (Intrinsics.areEqual((Object)information.getFileName(), (Object)".") || Intrinsics.areEqual((Object)information.getFileName(), (Object)"..")) continue;
            boolean isDir = (information.getFileAttributes() & FileAttributes.FILE_ATTRIBUTE_DIRECTORY.getValue()) != 0L;
            S3Path path2 = (S3Path)path.resolve(information.getFileName());
            S3FileAttributes s3FileAttributes = path2.getAttributes();
            boolean bl = !isDir;
            long l = information.getEndOfFile();
            long l2 = information.getLastWriteTime().toDate().getTime();
            long l3 = information.getLastAccessTime().toDate().getTime();
            path2.setAttributes(S3FileAttributes.copy$default((S3FileAttributes)s3FileAttributes, (long)l2, (long)l3, (long)0L, (boolean)bl, (boolean)isDir, (boolean)false, (boolean)false, (long)l, (int)100, null));
            Intrinsics.checkNotNull((Object)path2);
            paths.add(path2);
        }
        return paths;
    }

    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.share.mkdir(((Object)dir.toAbsolutePath()).toString());
    }

    public void delete(@NotNull S3Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (isDirectory) {
            this.share.rmdir(((Object)((Path)path).toAbsolutePath()).toString(), false);
        } else {
            this.share.rm(((Object)((Path)path).toAbsolutePath()).toString());
        }
    }

    public void checkAccess(@NotNull S3Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        if (this.share.fileExists(((Object)((Path)path).toAbsolutePath()).toString()) || this.share.folderExists(((Object)((Path)path).toAbsolutePath()).toString())) {
            return;
        }
        throw new NoSuchFileException(((Object)((Path)path).toAbsolutePath()).toString());
    }
}

