/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.ftp;

import app.termora.AuthenticationType;
import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.ProxyType;
import app.termora.plugins.ftp.FTPFileSystem;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/ftp/FTPProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "getProtocol", "", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "ftp"})
public final class FTPProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(FTPProtocolProvider.class);
    @NotNull
    private static final FTPProtocolProvider instance = new FTPProtocolProvider();
    @NotNull
    public static final String PROTOCOL = "FTP";

    private FTPProtocolProvider() {
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getFtp();
    }

    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        GenericObjectPoolConfig genericObjectPoolConfig;
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Host host = requester.getHost();
        GenericObjectPoolConfig $this$createPathHandler_u24lambda_u240 = genericObjectPoolConfig = new GenericObjectPoolConfig();
        boolean bl = false;
        $this$createPathHandler_u24lambda_u240.setMaxTotal(12);
        $this$createPathHandler_u24lambda_u240.setMaxIdle(6);
        $this$createPathHandler_u24lambda_u240.setMinIdle(1);
        $this$createPathHandler_u24lambda_u240.setTestOnBorrow(false);
        $this$createPathHandler_u24lambda_u240.setTestWhileIdle(true);
        $this$createPathHandler_u24lambda_u240.setTimeBetweenEvictionRuns(Duration.ofSeconds(30L));
        $this$createPathHandler_u24lambda_u240.setSoftMinEvictableIdleDuration(Duration.ofSeconds(30L));
        $this$createPathHandler_u24lambda_u240.setMinEvictableIdleDuration(Duration.ofMinutes(3L));
        GenericObjectPoolConfig config = genericObjectPoolConfig;
        GenericObjectPool ftpClientPool2 = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<FTPClient>(host){
            final /* synthetic */ Host $host;
            {
                this.$host = $host;
            }

            public FTPClient create() {
                String password;
                FTPClient client = new FTPClient();
                client.setCharset(Charset.forName(this.$host.getOptions().getEncoding()));
                client.setControlEncoding(client.getCharset().name());
                client.connect(this.$host.getHost(), this.$host.getPort());
                if (!client.isConnected()) {
                    throw new IllegalStateException("FTP client is not connected");
                }
                if (this.$host.getProxy().getType() == ProxyType.HTTP) {
                    client.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.$host.getProxy().getHost(), this.$host.getProxy().getPort())));
                } else if (this.$host.getProxy().getType() == ProxyType.SOCKS5) {
                    client.setProxy(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.$host.getProxy().getHost(), this.$host.getProxy().getPort())));
                }
                String string = password = this.$host.getAuthentication().getType() == AuthenticationType.Password ? this.$host.getAuthentication().getPassword() : "";
                if (!client.login(this.$host.getUsername(), password)) {
                    throw new IllegalStateException("Incorrect account or password");
                }
                if (Intrinsics.areEqual(this.$host.getOptions().getExtras().get("passive"), (Object)"Remote")) {
                    client.enterRemotePassiveMode();
                } else {
                    client.enterLocalPassiveMode();
                }
                client.setListHiddenFiles(true);
                return client;
            }

            public PooledObject<FTPClient> wrap(FTPClient obj) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                return (PooledObject)new DefaultPooledObject((Object)obj);
            }

            public boolean validateObject(PooledObject<FTPClient> p) {
                Intrinsics.checkNotNullParameter(p, (String)"p");
                FTPClient ftp = (FTPClient)p.getObject();
                return !ftp.isConnected() && ftp.sendNoOp();
            }

            public void destroyObject(PooledObject<FTPClient> p) {
                block2: {
                    Intrinsics.checkNotNullParameter(p, (String)"p");
                    try {
                        ((FTPClient)p.getObject()).disconnect();
                    }
                    catch (Exception e) {
                        if (!FTPProtocolProvider.access$getLog$cp().isWarnEnabled()) break block2;
                        FTPProtocolProvider.access$getLog$cp().warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }, config);
        String defaultPath = host.getOptions().getSftpDefaultDirectory();
        FTPFileSystem fs = new FTPFileSystem((GenericObjectPool<FTPClient>)ftpClientPool2);
        FileSystem fileSystem = (FileSystem)((Object)fs);
        Path path = fs.getPath(defaultPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new PathHandler(fileSystem, path);
    }

    public boolean isTransfer() {
        return super.isTransfer();
    }

    public boolean isTransient() {
        return super.isTransient();
    }

    public int ordered() {
        return super.ordered();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lapp/termora/plugins/ftp/FTPProtocolProvider$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "instance", "Lapp/termora/plugins/ftp/FTPProtocolProvider;", "getInstance", "()Lapp/termora/plugins/ftp/FTPProtocolProvider;", "PROTOCOL", "", "ftp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FTPProtocolProvider getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

