/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.serial;

import app.termora.Host;
import app.termora.SerialComm;
import app.termora.SerialCommFlowControl;
import app.termora.SerialCommParity;
import com.fazecast.jSerialComm.SerialPort;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/plugins/serial/Serials;", "", "<init>", "()V", "openPort", "Lcom/fazecast/jSerialComm/SerialPort;", "host", "Lapp/termora/Host;", "serial"})
public final class Serials {
    @NotNull
    public static final Serials INSTANCE = new Serials();

    private Serials() {
    }

    @NotNull
    public final SerialPort openPort(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        SerialComm serialComm = host.getOptions().getSerialComm();
        SerialPort serialPort = SerialPort.getCommPort((String)serialComm.getPort());
        serialPort.setBaudRate(serialComm.getBaudRate());
        serialPort.setNumDataBits(serialComm.getDataBits());
        switch (WhenMappings.$EnumSwitchMapping$0[serialComm.getParity().ordinal()]) {
            case 1: {
                boolean bl = serialPort.setParity(0);
                break;
            }
            case 2: {
                boolean bl = serialPort.setParity(3);
                break;
            }
            case 3: {
                boolean bl = serialPort.setParity(2);
                break;
            }
            case 4: {
                boolean bl = serialPort.setParity(1);
                break;
            }
            case 5: {
                boolean bl = serialPort.setParity(4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        switch (serialComm.getStopBits()) {
            case "1": {
                serialPort.setNumStopBits(1);
                break;
            }
            case "1.5": {
                serialPort.setNumStopBits(2);
                break;
            }
            case "2": {
                serialPort.setNumStopBits(3);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[serialComm.getFlowControl().ordinal()]) {
            case 1: {
                boolean bl = serialPort.setFlowControl(0);
                break;
            }
            case 2: {
                boolean bl = serialPort.setFlowControl(17);
                break;
            }
            case 3: {
                boolean bl = serialPort.setFlowControl(0x110000);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!serialPort.openPort()) {
            throw new IllegalStateException("Open serial port [" + serialComm.getPort() + "] failed");
        }
        Intrinsics.checkNotNull((Object)serialPort);
        return serialPort;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SerialCommParity.values().length];
            try {
                nArray[SerialCommParity.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SerialCommParity.Mark.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SerialCommParity.Even.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SerialCommParity.Odd.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SerialCommParity.Space.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SerialCommFlowControl.values().length];
            try {
                nArray[SerialCommFlowControl.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SerialCommFlowControl.RTS_CTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SerialCommFlowControl.XON_XOFF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

