/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.vnc;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.FixedLengthTextArea;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.Options;
import app.termora.OptionsPane;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.PortSpinner;
import app.termora.Proxy;
import app.termora.ProxyType;
import app.termora.plugin.internal.BasicProxyOption;
import app.termora.plugin.internal.BasicTerminalOption;
import app.termora.plugins.vnc.VNCHostOptionsPane;
import app.termora.plugins.vnc.VNCProtocolProvider;
import app.termora.protocol.ProtocolProvider;
import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\r\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lapp/termora/plugins/vnc/VNCHostOptionsPane;", "Lapp/termora/OptionsPane;", "<init>", "()V", "generalOption", "Lapp/termora/plugins/vnc/VNCHostOptionsPane$GeneralOption;", "getGeneralOption", "()Lapp/termora/plugins/vnc/VNCHostOptionsPane$GeneralOption;", "proxyOption", "Lapp/termora/plugin/internal/BasicProxyOption;", "getProxyOption", "()Lapp/termora/plugin/internal/BasicProxyOption;", "terminalOption", "app/termora/plugins/vnc/VNCHostOptionsPane$terminalOption$1", "Lapp/termora/plugins/vnc/VNCHostOptionsPane$terminalOption$1;", "owner", "Ljava/awt/Window;", "getOwner", "()Ljava/awt/Window;", "getHost", "Lapp/termora/Host;", "setHost", "", "host", "validateFields", "", "validateField", "textField", "Ljavax/swing/JTextField;", "setOutlineError", "GeneralOption", "vnc"})
public class VNCHostOptionsPane
extends OptionsPane {
    @NotNull
    private final GeneralOption generalOption = new GeneralOption();
    @NotNull
    private final BasicProxyOption proxyOption = new BasicProxyOption(null, CollectionsKt.emptyList(), 1, null);
    @NotNull
    private final terminalOption.1 terminalOption;

    /*
     * WARNING - void declaration
     */
    public VNCHostOptionsPane() {
        void $this$terminalOption_u24lambda_u240;
        BasicTerminalOption basicTerminalOption;
        BasicTerminalOption basicTerminalOption2 = basicTerminalOption = new BasicTerminalOption(){

            public String getTitle() {
                return "VNC";
            }

            public Icon getIcon(boolean isSelected) {
                return (Icon)ProtocolProvider.getIcon$default((ProtocolProvider)((ProtocolProvider)VNCProtocolProvider.Companion.getInstance()), (int)0, (int)0, (int)3, null);
            }
        };
        VNCHostOptionsPane vNCHostOptionsPane = this;
        boolean bl = false;
        $this$terminalOption_u24lambda_u240.setShowAltModifierComboBox(false);
        $this$terminalOption_u24lambda_u240.setShowCharsetComboBox(true);
        $this$terminalOption_u24lambda_u240.init();
        $this$terminalOption_u24lambda_u240.getCharsetComboBox().setSelectedItem("ISO-8859-1");
        vNCHostOptionsPane.terminalOption = basicTerminalOption;
        this.addOption(this.generalOption);
        this.addOption((OptionsPane.Option)this.proxyOption);
        this.addOption((OptionsPane.Option)this.terminalOption);
    }

    @NotNull
    protected final GeneralOption getGeneralOption() {
        return this.generalOption;
    }

    @NotNull
    protected final BasicProxyOption getProxyOption() {
        return this.proxyOption;
    }

    @NotNull
    protected final Window getOwner() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        return window;
    }

    @NotNull
    public Host getHost() {
        String string;
        Object object;
        Object object2;
        String string2;
        Object object3;
        String name = this.generalOption.getNameTextField().getText();
        String protocol = "VNC";
        String host = this.generalOption.getHostTextField().getText();
        Object object4 = this.generalOption.getPortTextField().getValue();
        if (object4 == null) {
            object4 = 5900;
        }
        int port = (Integer)object4;
        Authentication authentication = Authentication.Companion.getNo();
        Proxy proxy = Proxy.Companion.getNo();
        Object object5 = this.generalOption.getAuthenticationTypeComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
        AuthenticationType authenticationType = (AuthenticationType)object5;
        if (authenticationType == AuthenticationType.Password) {
            char[] cArray = this.generalOption.getPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            object3 = cArray;
            authentication = authentication.copy(authenticationType, new String((char[])object3));
        }
        if (this.proxyOption.getProxyTypeComboBox().getSelectedItem() != ProxyType.No) {
            object3 = proxy;
            Object object6 = this.proxyOption.getProxyTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type app.termora.ProxyType");
            string2 = (ProxyType)object6;
            String string3 = this.proxyOption.getProxyHostTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            object2 = string3;
            String string4 = this.proxyOption.getProxyUsernameTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            object = string4;
            char[] cArray = this.proxyOption.getProxyPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            char[] cArray2 = cArray;
            String string5 = new String(cArray2);
            Object object7 = this.proxyOption.getProxyPortTextField().getValue();
            Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)object7;
            Object object8 = this.proxyOption.getProxyAuthenticationTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
            string = (AuthenticationType)object8;
            proxy = object3.copy((ProxyType)string2, (String)object2, n, (AuthenticationType)string, (String)object, string5);
        }
        Intrinsics.checkNotNull((Object)name);
        object3 = name;
        Intrinsics.checkNotNull((Object)host);
        string2 = host;
        object2 = authentication;
        object = proxy;
        long l = System.currentTimeMillis();
        String string6 = this.generalOption.getRemarkTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        string = string6;
        Options options = Options.Companion.getDefault();
        Object object9 = this.terminalOption.getCharsetComboBox().getSelectedItem();
        if (object9 == null || (object9 = object9.toString()) == null) {
            object9 = "ISO-8859-1";
        }
        Options options2 = Options.copy$default((Options)options, null, null, (String)object9, null, null, (int)0, null, null, (boolean)false, null, null, null, (int)4091, null);
        return new Host(null, (String)object3, protocol, string2, port, null, string, object2, object, options2, null, l, null, null, null, null, false, 0L, 0L, 521249, null);
    }

    public final void setHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.generalOption.getPortTextField().setValue((Object)host.getPort());
        this.generalOption.getNameTextField().setText(host.getName());
        this.generalOption.getHostTextField().setText(host.getHost());
        this.generalOption.getRemarkTextArea().setText(host.getRemark());
        this.generalOption.getAuthenticationTypeComboBox().setSelectedItem((Object)host.getAuthentication().getType());
        if (host.getAuthentication().getType() == AuthenticationType.Password) {
            this.generalOption.getPasswordTextField().setText(host.getAuthentication().getPassword());
        }
        this.terminalOption.getCharsetComboBox().setSelectedItem(StringUtils.defaultIfBlank((CharSequence)host.getOptions().getEncoding(), (CharSequence)"ISO-8859-1"));
        this.proxyOption.getProxyTypeComboBox().setSelectedItem((Object)host.getProxy().getType());
        this.proxyOption.getProxyHostTextField().setText(host.getProxy().getHost());
        this.proxyOption.getProxyPasswordTextField().setText(host.getProxy().getPassword());
        this.proxyOption.getProxyUsernameTextField().setText(host.getProxy().getUsername());
        this.proxyOption.getProxyPortTextField().setValue((Object)host.getProxy().getPort());
        this.proxyOption.getProxyAuthenticationTypeComboBox().setSelectedItem((Object)host.getProxy().getAuthenticationType());
    }

    public final boolean validateFields() {
        Host host = this.getHost();
        if (this.validateField((JTextField)this.generalOption.getNameTextField()) || this.validateField((JTextField)this.generalOption.getHostTextField())) {
            return false;
        }
        if (host.getAuthentication().getType() == AuthenticationType.Password && this.validateField((JTextField)this.generalOption.getPasswordTextField())) {
            return false;
        }
        if (host.getProxy().getType() != ProxyType.No) {
            if (this.validateField((JTextField)this.proxyOption.getProxyHostTextField())) {
                return false;
            }
            if (host.getProxy().getAuthenticationType() != AuthenticationType.No && (this.validateField((JTextField)this.proxyOption.getProxyUsernameTextField()) || this.validateField((JTextField)this.proxyOption.getProxyPasswordTextField()))) {
                return false;
            }
        }
        return true;
    }

    private final boolean validateField(JTextField textField) {
        if (textField.isEnabled()) {
            String string = textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setOutlineError(textField);
                return true;
            }
        }
        return false;
    }

    private final void setOutlineError(JTextField textField) {
        this.selectOptionJComponent(textField);
        textField.putClientProperty("JComponent.outline", "error");
        textField.requestFocusInWindow();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lapp/termora/plugins/vnc/VNCHostOptionsPane$GeneralOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugins/vnc/VNCHostOptionsPane;)V", "portTextField", "Lapp/termora/PortSpinner;", "getPortTextField", "()Lapp/termora/PortSpinner;", "nameTextField", "Lapp/termora/OutlineTextField;", "getNameTextField", "()Lapp/termora/OutlineTextField;", "hostTextField", "getHostTextField", "passwordTextField", "Lapp/termora/OutlinePasswordField;", "getPasswordTextField", "()Lapp/termora/OutlinePasswordField;", "remarkTextArea", "Lapp/termora/FixedLengthTextArea;", "getRemarkTextArea", "()Lapp/termora/FixedLengthTextArea;", "authenticationTypeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "Lapp/termora/AuthenticationType;", "getAuthenticationTypeComboBox", "()Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "vnc"})
    @SourceDebugExtension(value={"SMAP\nVNCHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VNCHostOptionsPane.kt\napp/termora/plugins/vnc/VNCHostOptionsPane$GeneralOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1#2:304\n*E\n"})
    protected final class GeneralOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final PortSpinner portTextField;
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField hostTextField;
        @NotNull
        private final OutlinePasswordField passwordTextField;
        @NotNull
        private final FixedLengthTextArea remarkTextArea;
        @NotNull
        private final FlatComboBox<AuthenticationType> authenticationTypeComboBox;

        public GeneralOption() {
            super(new BorderLayout());
            this.portTextField = new PortSpinner(5900);
            this.nameTextField = new OutlineTextField(128);
            this.hostTextField = new OutlineTextField(255);
            this.passwordTextField = new OutlinePasswordField(255, false, 2, null);
            this.remarkTextArea = new FixedLengthTextArea(512);
            this.authenticationTypeComboBox = new FlatComboBox();
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final PortSpinner getPortTextField() {
            return this.portTextField;
        }

        @NotNull
        public final OutlineTextField getNameTextField() {
            return this.nameTextField;
        }

        @NotNull
        public final OutlineTextField getHostTextField() {
            return this.hostTextField;
        }

        @NotNull
        public final OutlinePasswordField getPasswordTextField() {
            return this.passwordTextField;
        }

        @NotNull
        public final FixedLengthTextArea getRemarkTextArea() {
            return this.remarkTextArea;
        }

        @NotNull
        public final FlatComboBox<AuthenticationType> getAuthenticationTypeComboBox() {
            return this.authenticationTypeComboBox;
        }

        private final void initView() {
            this.add((Component)this.getCenterComponent(), "Center");
            this.authenticationTypeComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object object;
                    Object text;
                    Object object2 = value;
                    if (object2 == null || (object2 = object2.toString()) == null) {
                        object2 = text = "";
                    }
                    if ((object = value) == AuthenticationType.Password) {
                        text = "Password";
                    } else if (object == AuthenticationType.PublicKey) {
                        text = "Public Key";
                    } else if (object == AuthenticationType.KeyboardInteractive) {
                        text = "Keyboard Interactive";
                    }
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.No);
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.Password);
            this.authenticationTypeComboBox.setSelectedItem((Object)AuthenticationType.Password);
        }

        private final void initEvents() {
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> initEvents.1.componentResized$lambda$0(this.this$0));
                    this.this$0.removeComponentListener(this);
                }

                private static final void componentResized$lambda$0(GeneralOption this$0) {
                    this$0.getNameTextField().requestFocusInWindow();
                }
            });
            this.authenticationTypeComboBox.addItemListener(arg_0 -> GeneralOption.initEvents$lambda$0(this, arg_0));
        }

        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)Icons.INSTANCE.getSettings();
        }

        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.general");
        }

        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent getCenterComponent() {
            void $this$getCenterComponent_u24lambda_u245;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, pref, 7dlu, default", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            this.remarkTextArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.remarkTextArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
            this.remarkTextArea.setRows(8);
            this.remarkTextArea.setLineWrap(true);
            this.remarkTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = object = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.new-host.general.name") + ":", new Object[0]).xy(1, rows).add((Component)this.nameTextField).xyw(3, rows, 5);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u242 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.host") + ":", new Object[0]).xy(1, rows += step).add((Component)this.hostTextField).xy(3, rows).add(I18n.INSTANCE.getString("termora.new-host.general.port") + ":", new Object[0]).xy(5, rows).add((Component)this.portTextField).xy(7, rows);
            boolean bl2 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u243 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.authentication") + ":", new Object[0]).xy(1, rows += step).add((Component)this.authenticationTypeComboBox).xyw(3, rows, 5);
            boolean bl3 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u244 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.password") + ":", new Object[0]).xy(1, rows += step).add((Component)this.passwordTextField).xyw(3, rows, 5);
            boolean bl4 = false;
            FormBuilder formBuilder = object.add(I18n.INSTANCE.getString("termora.new-host.general.remark") + ":", new Object[0]).xy(1, rows += step);
            $this$getCenterComponent_u24lambda_u244 = object = new JScrollPane((Component)this.remarkTextArea);
            FormBuilder formBuilder2 = formBuilder;
            boolean bl5 = false;
            $this$getCenterComponent_u24lambda_u245.setBorder((Border)new FlatTextBorder());
            Object $this$getCenterComponent_u24lambda_u246 = object = formBuilder2.add((Component)object).xyw(3, rows, 5);
            boolean bl6 = false;
            rows += step;
            JPanel panel = object.build();
            Intrinsics.checkNotNull((Object)panel);
            return panel;
        }

        @NotNull
        public String getIdentifier() {
            return super.getIdentifier();
        }

        @NotNull
        public OptionsPane.Anchor getAnchor() {
            return super.getAnchor();
        }

        public void onSelected() {
            super.onSelected();
        }

        private static final void initEvents$lambda$0(GeneralOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                this$0.passwordTextField.setEnabled(this$0.authenticationTypeComboBox.getSelectedItem() == AuthenticationType.Password);
            }
        }
    }
}

