/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.auth;

import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.RfbCapabilityInfo;
import com.glavsoft.rfb.encoding.ServerInitMessage;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.auth.SecurityType;
import com.glavsoft.rfb.protocol.tunnel.TunnelHandler;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import java.util.HashMap;
import java.util.Map;

public class TightAuthentication
extends AuthHandler {
    private final Map<Integer, AuthHandler> registeredAuthHandlers = new HashMap<Integer, AuthHandler>();
    private final Map<Integer, TunnelHandler> registeredTunnelHandlers = new HashMap<Integer, TunnelHandler>();

    public void registerTunnelingHandler(TunnelHandler handler) {
        this.registeredTunnelHandlers.put(handler.getId(), handler);
    }

    public void registerAuthHandler(AuthHandler handler) {
        this.registeredAuthHandlers.put(handler.getId(), handler);
    }

    @Override
    public SecurityType getType() {
        return SecurityType.TIGHT_AUTHENTICATION;
    }

    @Override
    public Transport authenticate(Transport transport, Protocol protocol) throws TransportException, FatalException, UnsupportedSecurityTypeException {
        transport = this.tunnelingNegotiation(transport, protocol);
        this.authorizationNegotiation(transport, protocol);
        protocol.setTight(true);
        return transport;
    }

    @Override
    public void initProcedure(Transport transport, Protocol protocol) throws TransportException {
        this.capabilitiesNegotiation(transport, protocol);
        protocol.registerRfbEncodings();
    }

    void capabilitiesNegotiation(Transport transport, Protocol protocol) throws TransportException {
        this.sendClientInitMessage(transport, protocol.getSettings().getSharedFlag());
        ServerInitMessage serverInitMessage = this.readServerInitMessage(transport);
        int nServerMessageTypes = transport.readUInt16();
        int nClientMessageTypes = transport.readUInt16();
        int nEncodingTypes = transport.readUInt16();
        transport.readUInt16();
        this.logger().fine("nServerMessageTypes: " + nServerMessageTypes + ", nClientMessageTypes: " + nClientMessageTypes + ", nEncodingTypes: " + nEncodingTypes);
        this.registerServerMessagesTypes(transport, protocol, nServerMessageTypes);
        this.registerClientMessagesTypes(transport, protocol, nClientMessageTypes);
        this.registerEncodings(transport, protocol, nEncodingTypes);
        this.completeContextData(serverInitMessage, protocol);
    }

    private void registerServerMessagesTypes(Transport transport, Protocol protocol, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo().readFrom(transport);
            this.logger().fine("Server message type: " + capInfoReceived.toString());
        }
    }

    private void registerClientMessagesTypes(Transport transport, Protocol protocol, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo().readFrom(transport);
            this.logger().fine("Client message type: " + capInfoReceived.toString());
            protocol.registerClientMessageType(capInfoReceived);
        }
    }

    private void registerEncodings(Transport transport, Protocol protocol, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo().readFrom(transport);
            this.logger().fine("Encoding: " + capInfoReceived.toString());
            protocol.registerEncoding(capInfoReceived);
        }
    }

    Transport tunnelingNegotiation(Transport transport, Protocol protocol) throws TransportException {
        Transport newTransport = transport;
        int tunnelsCount = (int)transport.readUInt32();
        this.logger().fine("Tunneling capabilities: " + tunnelsCount);
        int[] tunnelCodes = new int[tunnelsCount];
        if (tunnelsCount > 0) {
            for (int i = 0; i < tunnelsCount; ++i) {
                RfbCapabilityInfo rfbCapabilityInfo = new RfbCapabilityInfo().readFrom(transport);
                tunnelCodes[i] = rfbCapabilityInfo.getCode();
                this.logger().fine(rfbCapabilityInfo.toString());
            }
            if (tunnelsCount > 0) {
                for (int i = 0; i < tunnelsCount; ++i) {
                    TunnelHandler tunnelHandler = this.registeredTunnelHandlers.get(tunnelCodes[i]);
                    if (tunnelHandler == null) continue;
                    int selectedTunnelCode = tunnelCodes[i];
                    transport.writeInt32(selectedTunnelCode).flush();
                    this.logger().fine("Accepted tunneling type: " + selectedTunnelCode);
                    newTransport = tunnelHandler.createTunnel(transport);
                    this.logger().fine("Tunnel created: " + String.valueOf((Object)TunnelType.byCode(selectedTunnelCode)));
                    protocol.setTunnelType(TunnelType.byCode(selectedTunnelCode));
                    break;
                }
            }
        }
        if (protocol.getTunnelType() == null) {
            protocol.setTunnelType(TunnelType.NOTUNNEL);
            if (tunnelsCount > 0) {
                transport.writeInt32(TunnelType.NOTUNNEL.code).flush();
            }
            this.logger().fine("Accepted tunneling type: " + String.valueOf((Object)TunnelType.NOTUNNEL));
        }
        return newTransport;
    }

    void authorizationNegotiation(Transport transport, Protocol protocol) throws UnsupportedSecurityTypeException, TransportException, FatalException {
        int authCount = transport.readInt32();
        this.logger().fine("Auth capabilities: " + authCount);
        byte[] cap = new byte[authCount];
        for (int i = 0; i < authCount; ++i) {
            RfbCapabilityInfo rfbCapabilityInfo = new RfbCapabilityInfo().readFrom(transport);
            cap[i] = (byte)rfbCapabilityInfo.getCode();
            this.logger().fine(rfbCapabilityInfo.toString());
        }
        AuthHandler authHandler = null;
        if (authCount > 0) {
            for (int i = 0; i < authCount; ++i) {
                authHandler = this.registeredAuthHandlers.get(cap[i]);
                if (authHandler == null) continue;
                transport.writeInt32(authHandler.getId()).flush();
                break;
            }
        } else {
            authHandler = this.registeredAuthHandlers.get(SecurityType.NONE_AUTHENTICATION.getId());
        }
        if (null == authHandler) {
            throw new UnsupportedSecurityTypeException("Server auth types: " + Strings.toString(cap) + ", supported auth types: " + String.valueOf(this.registeredAuthHandlers.values()));
        }
        this.logger().fine("Auth capability accepted: " + authHandler.getName());
        authHandler.authenticate(transport, protocol);
    }
}

