/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.tunnel;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.protocol.tunnel.TunnelHandler;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.transport.Transport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslTunnel
implements TunnelHandler {
    private static final String PROTOCOL = "TLSv1.1";
    private static final String SSL_TRANSPORT = "com.glavsoft.transport.SslTransport";

    @Override
    public int getId() {
        return TunnelType.SSL.code;
    }

    @Override
    public Transport createTunnel(Transport transport) throws TransportException {
        try {
            SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
            sslContext.init(null, this.getTrustAllCertsManager(), null);
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setUseClientMode(true);
            Class<?> sslTransportClass = Class.forName(SSL_TRANSPORT);
            Constructor<?> constructor = sslTransportClass.getConstructor(Transport.class, SSLEngine.class);
            return (Transport)constructor.newInstance(transport, engine);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel", e);
        }
        catch (KeyManagementException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel", e);
        }
        catch (ClassNotFoundException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel, SSL transport plugin unavailable", e);
        }
        catch (NoSuchMethodException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel, SSL transport plugin unavailable", e);
        }
        catch (InvocationTargetException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel, SSL transport plugin unavailable", e);
        }
        catch (InstantiationException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel, SSL transport plugin unavailable", e);
        }
        catch (IllegalAccessException e) {
            throw new TransportException("Cannot create SSL/TLS tunnel, SSL transport plugin unavailable", e);
        }
    }

    private TrustManager[] getTrustAllCertsManager() {
        return new TrustManager[]{new X509TrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    public static boolean isTransportAvailable() {
        try {
            Class.forName(SSL_TRANSPORT);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

