/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.mvp;

import com.glavsoft.viewer.mvp.Model;
import com.glavsoft.viewer.mvp.PropertyNotFoundException;
import com.glavsoft.viewer.mvp.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Presenter {
    private final Map<String, View> registeredViews = new HashMap<String, View>();
    private final Map<String, Model> registeredModels = new HashMap<String, Model>();
    private static Logger logger = Logger.getLogger(Presenter.class.getName());
    private Throwable savedInvocationTargetException;

    public void addView(String name, View view) {
        this.registeredViews.put(name, view);
    }

    public Set<Map.Entry<String, View>> removeAllViews() {
        Set<Map.Entry<String, View>> save = this.registeredViews.entrySet();
        this.registeredViews.clear();
        return save;
    }

    public void addModel(String name, Model model) {
        this.registeredModels.put(name, model);
    }

    protected void populate() {
        this.savedInvocationTargetException = null;
        for (Map.Entry<String, Model> entry : this.registeredModels.entrySet()) {
            String modelName = entry.getKey();
            Model model = entry.getValue();
            this.populateFrom(modelName, model);
        }
    }

    public void populateFrom(String modelName) {
        Model model = this.registeredModels.get(modelName);
        if (model != null) {
            this.populateFrom(modelName, model);
        } else {
            logger.finer("Cannot find model: " + modelName);
        }
    }

    private void populateFrom(String modelName, Model model) {
        Method[] methods;
        for (Method m : methods = model.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0) continue;
            String propertyName = m.getName().substring(3);
            try {
                Object property = m.invoke((Object)model, new Object[0]);
                logger.finest("Load: " + modelName + ".get" + propertyName + "() # => " + String.valueOf(property) + "  type: " + String.valueOf(m.getReturnType()));
                this.setViewProperty(propertyName, property, m.getReturnType());
            }
            catch (IllegalAccessException property) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
        }
    }

    protected boolean isModelRegisteredByName(String modelName) {
        return this.registeredModels.containsKey(modelName);
    }

    protected Model getModel(String modelName) {
        return this.registeredModels.get(modelName);
    }

    protected void show() {
        for (View v : this.registeredViews.values()) {
            v.showView();
        }
    }

    protected void save() {
        this.savedInvocationTargetException = null;
        block4: for (Map.Entry<String, Model> entry : this.registeredModels.entrySet()) {
            Method[] methods;
            String modelName = entry.getKey();
            Model model = entry.getValue();
            for (Method m : methods = model.getClass().getDeclaredMethods()) {
                if (!m.getName().startsWith("set")) continue;
                String propertyName = m.getName().substring(3);
                try {
                    Object viewProperty = this.getViewProperty(propertyName);
                    m.invoke((Object)model, viewProperty);
                    logger.finest("Save: " + modelName + ".set" + propertyName + "( " + String.valueOf(viewProperty) + " )");
                }
                catch (IllegalAccessException viewProperty) {
                }
                catch (InvocationTargetException e) {
                    this.savedInvocationTargetException = e.getCause();
                    continue block4;
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public Object getViewPropertyOrNull(String propertyName) {
        try {
            return this.getViewProperty(propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public Object getViewProperty(String propertyName) throws PropertyNotFoundException {
        this.savedInvocationTargetException = null;
        logger.finest("get" + propertyName + "()");
        for (Map.Entry<String, View> entry : this.registeredViews.entrySet()) {
            String viewName = entry.getKey();
            View view = entry.getValue();
            try {
                Method getter = view.getClass().getMethod("get" + propertyName, new Class[0]);
                Object res = getter.invoke((Object)view, new Object[0]);
                logger.finest("----from view: " + viewName + ".get" + propertyName + "() # +> " + String.valueOf(res));
                return res;
            }
            catch (NoSuchMethodException getter) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        throw new PropertyNotFoundException(propertyName);
    }

    public Object getModelProperty(String propertyName) {
        this.savedInvocationTargetException = null;
        logger.finest("get" + propertyName + "()");
        for (String modelName : this.registeredModels.keySet()) {
            Model model = this.registeredModels.get(modelName);
            try {
                Method getter = model.getClass().getMethod("get" + propertyName, new Class[0]);
                Object res = getter.invoke((Object)model, new Object[0]);
                logger.finest("----from model: " + modelName + ".get" + propertyName + "() # +> " + String.valueOf(res));
                return res;
            }
            catch (NoSuchMethodException getter) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return null;
    }

    public void setViewProperty(String propertyName, Object newValue) {
        this.setViewProperty(propertyName, newValue, newValue.getClass());
    }

    public void setViewProperty(String propertyName, Object newValue, Class<?> valueType) {
        this.savedInvocationTargetException = null;
        logger.finest("set" + propertyName + "( " + String.valueOf(newValue) + " ) type: " + String.valueOf(valueType));
        for (Map.Entry<String, View> entry : this.registeredViews.entrySet()) {
            String viewName = entry.getKey();
            View view = entry.getValue();
            try {
                Method setter = view.getClass().getMethod("set" + propertyName, valueType);
                setter.invoke((Object)view, newValue);
                logger.finest("----to view: " + viewName + ".set" + propertyName + "( " + String.valueOf(newValue) + " )");
            }
            catch (NoSuchMethodException setter) {
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
    }

    protected void throwPossiblyHappenedException() throws Throwable {
        if (this.savedInvocationTargetException != null) {
            Throwable tmp = this.savedInvocationTargetException;
            this.savedInvocationTargetException = null;
            throw tmp;
        }
    }

    protected View getView(String name) {
        return this.registeredViews.get(name);
    }

    public void setModelProperty(String propertyName, Object newValue) {
        this.setModelProperty(propertyName, newValue, newValue.getClass());
    }

    public void setModelProperty(String propertyName, Object newValue, Class<?> valueType) {
        this.savedInvocationTargetException = null;
        logger.finest("set" + propertyName + "( " + String.valueOf(newValue) + " )");
        for (Map.Entry<String, Model> entry : this.registeredModels.entrySet()) {
            String modelName = entry.getKey();
            Model model = entry.getValue();
            try {
                Method method = model.getClass().getMethod("set" + propertyName, valueType);
                method.invoke((Object)model, newValue);
                logger.finest("----for model: " + modelName);
            }
            catch (NoSuchMethodException method) {
            }
            catch (InvocationTargetException e) {
                this.savedInvocationTargetException = e.getCause();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
    }
}

