/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.client.PointerEventMessage;
import com.glavsoft.rfb.protocol.Protocol;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.event.MouseInputAdapter;

public class MouseEventListener
extends MouseInputAdapter
implements MouseWheelListener {
    private static final byte BUTTON_LEFT = 1;
    private static final byte BUTTON_MIDDLE = 2;
    private static final byte BUTTON_RIGHT = 4;
    private static final byte WHEEL_UP = 8;
    private static final byte WHEEL_DOWN = 16;
    private final IRepaintController repaintController;
    private final Protocol protocol;
    private volatile double scaleFactor;

    public MouseEventListener(IRepaintController repaintController, Protocol protocol, double scaleFactor) {
        this.repaintController = repaintController;
        this.protocol = protocol;
        this.scaleFactor = scaleFactor;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MouseWheelEvent mouseWheelEvent, boolean moved) {
        int modifiersEx;
        byte buttonMask = 0;
        if (null == mouseEvent && mouseWheelEvent != null) {
            mouseEvent = mouseWheelEvent;
        }
        assert (mouseEvent != null);
        short x = (short)((double)mouseEvent.getX() / this.scaleFactor);
        short y = (short)((double)mouseEvent.getY() / this.scaleFactor);
        if (moved) {
            this.repaintController.updateCursorPosition(x, y);
        }
        buttonMask = (byte)(buttonMask | (((modifiersEx = mouseEvent.getModifiersEx()) & 0x400) != 0 ? 1 : 0));
        buttonMask = (byte)(buttonMask | ((modifiersEx & 0x800) != 0 ? 2 : 0));
        buttonMask = (byte)(buttonMask | ((modifiersEx & 0x1000) != 0 ? 4 : 0));
        if (mouseWheelEvent != null) {
            int notches = mouseWheelEvent.getWheelRotation();
            int wheelMask = notches < 0 ? 8 : 16;
            notches = Math.abs(notches);
            for (int i = 1; i < notches; ++i) {
                this.protocol.sendMessage(new PointerEventMessage((byte)(buttonMask | wheelMask), x, y));
                this.protocol.sendMessage(new PointerEventMessage(buttonMask, x, y));
            }
            this.protocol.sendMessage(new PointerEventMessage((byte)(buttonMask | wheelMask), x, y));
        }
        this.protocol.sendMessage(new PointerEventMessage(buttonMask, x, y));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.getComponent().requestFocusInWindow();
        this.processMouseEvent(mouseEvent, null, false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent, null, false);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent, null, true);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent, null, true);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent emouseWheelEvent) {
        this.processMouseEvent(null, emouseWheelEvent, false);
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }
}

