/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.mvp.Model;
import com.glavsoft.viewer.settings.ConnectionParams;
import com.glavsoft.viewer.settings.UiSettings;
import com.glavsoft.viewer.settings.UiSettingsData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ConnectionsHistory
implements Model {
    private static int MAX_ITEMS = 32;
    public static final String CONNECTIONS_HISTORY_ROOT_NODE = "com/glavsoft/viewer/connectionsHistory";
    public static final String NODE_HOST_NAME = "hostName";
    public static final String NODE_PORT_NUMBER = "portNumber";
    public static final String NODE_SSH_USER_NAME = "sshUserName";
    public static final String NODE_SSH_HOST_NAME = "sshHostName";
    public static final String NODE_SSH_PORT_NUMBER = "sshPortNumber";
    public static final String NODE_USE_SSH = "useSsh";
    public static final String NODE_PROTOCOL_SETTINGS = "protocolSettings";
    public static final String NODE_UI_SETTINGS = "uiSettings";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<ConnectionParams, ProtocolSettings> protocolSettingsMap;
    private Map<ConnectionParams, UiSettingsData> uiSettingsDataMap;
    LinkedList<ConnectionParams> connections;

    public ConnectionsHistory() {
        this.init();
        this.retrieve();
    }

    private void init() {
        this.protocolSettingsMap = new HashMap<ConnectionParams, ProtocolSettings>();
        this.uiSettingsDataMap = new HashMap<ConnectionParams, UiSettingsData>();
        this.connections = new LinkedList();
    }

    private void retrieve() {
        Preferences connectionsHistoryNode;
        try {
            connectionsHistoryNode = this.getConnectionHistoryNode();
        }
        catch (SecurityException ace) {
            return;
        }
        try {
            String[] orderNums = connectionsHistoryNode.childrenNames();
            TreeMap<Integer, ConnectionParams> conns = new TreeMap<Integer, ConnectionParams>();
            HashSet<ConnectionParams> uniques = new HashSet<ConnectionParams>();
            for (String orderNum : orderNums) {
                ConnectionParams cp;
                int num = 0;
                try {
                    num = Integer.parseInt(orderNum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Preferences node = connectionsHistoryNode.node(orderNum);
                String hostName = node.get(NODE_HOST_NAME, null);
                if (null == hostName || uniques.contains(cp = new ConnectionParams(hostName, node.getInt(NODE_PORT_NUMBER, 0), node.getBoolean(NODE_USE_SSH, false), node.get(NODE_SSH_HOST_NAME, ""), node.getInt(NODE_SSH_PORT_NUMBER, 0), node.get(NODE_SSH_USER_NAME, "")))) continue;
                uniques.add(cp);
                conns.put(num, cp);
                this.logger.finest("deserialialize: " + cp.toPrint());
                this.retrieveProtocolSettings(node, cp);
                this.retrieveUiSettings(node, cp);
            }
            int itemsCount = 0;
            for (ConnectionParams cp : conns.values()) {
                if (itemsCount < MAX_ITEMS) {
                    this.connections.add(cp);
                } else {
                    connectionsHistoryNode.node(cp.hostName).removeNode();
                }
                ++itemsCount;
            }
        }
        catch (BackingStoreException e) {
            this.logger.severe("Cannot retrieve connections history info: " + e.getMessage());
        }
    }

    private void retrieveUiSettings(Preferences node, ConnectionParams cp) {
        byte[] bytes = node.getByteArray(NODE_UI_SETTINGS, new byte[0]);
        if (bytes.length != 0) {
            try {
                UiSettingsData settings = (UiSettingsData)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
                this.uiSettingsDataMap.put(cp, settings);
                this.logger.finest("deserialialize: " + String.valueOf(settings));
            }
            catch (IOException e) {
                this.logger.info("Cannot deserialize UiSettings: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                this.logger.severe("Cannot deserialize UiSettings : " + e.getMessage());
            }
        }
    }

    private void retrieveProtocolSettings(Preferences node, ConnectionParams cp) {
        byte[] bytes = node.getByteArray(NODE_PROTOCOL_SETTINGS, new byte[0]);
        if (bytes.length != 0) {
            try {
                ProtocolSettings settings = (ProtocolSettings)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
                this.protocolSettingsMap.put(cp, settings);
                this.logger.finest("deserialialize: " + String.valueOf(settings));
            }
            catch (IOException e) {
                this.logger.info("Cannot deserialize ProtocolSettings: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                this.logger.severe("Cannot deserialize ProtocolSettings : " + e.getMessage());
            }
        }
    }

    public LinkedList<ConnectionParams> getConnectionsList() {
        return this.connections;
    }

    public ProtocolSettings getProtocolSettings(ConnectionParams cp) {
        return this.protocolSettingsMap.get(cp);
    }

    public UiSettingsData getUiSettingsData(ConnectionParams cp) {
        return this.uiSettingsDataMap.get(cp);
    }

    public void save() {
        try {
            this.cleanStorage();
            Preferences connectionsHistoryNode = this.getConnectionHistoryNode();
            int num = 0;
            for (ConnectionParams cp : this.connections) {
                if (num < MAX_ITEMS) {
                    if (Strings.isTrimmedEmpty(cp.hostName)) continue;
                    this.addNode(cp, connectionsHistoryNode, num++);
                    continue;
                }
                break;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void clear() {
        this.cleanStorage();
        this.init();
    }

    private void cleanStorage() {
        Preferences connectionsHistoryNode = this.getConnectionHistoryNode();
        try {
            for (String host : connectionsHistoryNode.childrenNames()) {
                connectionsHistoryNode.node(host).removeNode();
            }
        }
        catch (BackingStoreException e) {
            this.logger.severe("Cannot remove node: " + e.getMessage());
        }
    }

    private Preferences getConnectionHistoryNode() {
        Preferences root = Preferences.userRoot();
        return root.node(CONNECTIONS_HISTORY_ROOT_NODE);
    }

    private void addNode(ConnectionParams connectionParams, Preferences connectionsHistoryNode, int orderNum) {
        ProtocolSettings protocolSettings = this.protocolSettingsMap.get(connectionParams);
        UiSettingsData uiSettingsData = this.uiSettingsDataMap.get(connectionParams);
        Preferences node = connectionsHistoryNode.node(String.valueOf(orderNum));
        this.serializeConnectionParams(node, connectionParams);
        this.serializeProtocolSettings(node, protocolSettings);
        this.serializeUiSettingsData(node, uiSettingsData);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            this.logger.severe("Cannot retrieve connections history info: " + e.getMessage());
        }
    }

    private void serializeUiSettingsData(Preferences node, UiSettingsData uiSettingsData) {
        if (uiSettingsData != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(uiSettingsData);
                node.putByteArray(NODE_UI_SETTINGS, byteArrayOutputStream.toByteArray());
                this.logger.finest("serialized (" + node.name() + ") " + String.valueOf(uiSettingsData));
            }
            catch (IOException e) {
                this.logger.severe("Cannot serialize UiSettings: " + e.getMessage());
            }
        }
    }

    private void serializeProtocolSettings(Preferences node, ProtocolSettings protocolSettings) {
        if (protocolSettings != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(protocolSettings);
                node.putByteArray(NODE_PROTOCOL_SETTINGS, byteArrayOutputStream.toByteArray());
                this.logger.finest("serialized (" + node.name() + ") " + String.valueOf(protocolSettings));
            }
            catch (IOException e) {
                this.logger.severe("Cannot serialize ProtocolSettings: " + e.getMessage());
            }
        }
    }

    private void serializeConnectionParams(Preferences node, ConnectionParams connectionParams) {
        node.put(NODE_HOST_NAME, connectionParams.hostName);
        node.putInt(NODE_PORT_NUMBER, connectionParams.getPortNumber());
        if (connectionParams.useSsh()) {
            node.putBoolean(NODE_USE_SSH, connectionParams.useSsh());
            node.put(NODE_SSH_USER_NAME, connectionParams.sshUserName != null ? connectionParams.sshUserName : "");
            node.put(NODE_SSH_HOST_NAME, connectionParams.sshHostName != null ? connectionParams.sshHostName : "");
            node.putInt(NODE_SSH_PORT_NUMBER, connectionParams.getSshPortNumber());
        }
        this.logger.finest("serialized (" + node.name() + ") " + connectionParams.toPrint());
    }

    public void reorder(ConnectionParams connectionParams) {
        this.reorder(connectionParams, this.getProtocolSettings(connectionParams), this.getUiSettingsData(connectionParams));
    }

    public void reorder(ConnectionParams connectionParams, ProtocolSettings protocolSettings, UiSettings uiSettings) {
        this.reorder(connectionParams, protocolSettings, uiSettings != null ? uiSettings.getData() : null);
    }

    private void reorder(ConnectionParams connectionParams, ProtocolSettings protocolSettings, UiSettingsData uiSettingsData) {
        while (this.connections.remove(connectionParams)) {
        }
        LinkedList<ConnectionParams> cpList = new LinkedList<ConnectionParams>();
        cpList.addAll(this.connections);
        this.connections.clear();
        this.connections.add(new ConnectionParams(connectionParams));
        this.connections.addAll(cpList);
        this.storeSettings(connectionParams, protocolSettings, uiSettingsData);
    }

    private void storeSettings(ConnectionParams connectionParams, ProtocolSettings protocolSettings, UiSettingsData uiSettingsData) {
        if (protocolSettings != null) {
            ProtocolSettings savedSettings = this.protocolSettingsMap.get(connectionParams);
            if (savedSettings != null) {
                savedSettings.copyDataFrom(protocolSettings);
            } else {
                this.protocolSettingsMap.put(new ConnectionParams(connectionParams), new ProtocolSettings(protocolSettings));
            }
        }
        if (uiSettingsData != null) {
            this.uiSettingsDataMap.put(new ConnectionParams(connectionParams), new UiSettingsData(uiSettingsData));
        }
    }

    public ConnectionParams getMostSuitableConnection(ConnectionParams orig) {
        ConnectionParams res;
        ConnectionParams connectionParams = res = this.connections.isEmpty() ? orig : this.connections.get(0);
        if (null == orig || Strings.isTrimmedEmpty(orig.hostName)) {
            return res;
        }
        for (ConnectionParams cp : this.connections) {
            if (orig.equals(cp)) {
                return cp;
            }
            if (this.compareTextFields(orig.hostName, res.hostName, cp.hostName)) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && this.comparePorts(orig.getPortNumber(), res.getPortNumber(), cp.getPortNumber())) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && orig.getPortNumber() == cp.getPortNumber() && orig.useSsh() == cp.useSsh() && orig.useSsh() != res.useSsh()) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && orig.getPortNumber() == cp.getPortNumber() && orig.useSsh() && cp.useSsh() && this.compareTextFields(orig.sshHostName, res.sshHostName, cp.sshHostName)) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && orig.getPortNumber() == cp.getPortNumber() && orig.useSsh() && cp.useSsh() && orig.sshHostName != null && orig.sshHostName.equals(cp.hostName) && this.comparePorts(orig.getSshPortNumber(), res.getSshPortNumber(), cp.getSshPortNumber())) {
                res = cp;
                continue;
            }
            if (!orig.hostName.equals(cp.hostName) || orig.getPortNumber() != cp.getPortNumber() || !orig.useSsh() || !cp.useSsh() || orig.sshHostName == null || !orig.sshHostName.equals(cp.hostName) || orig.getSshPortNumber() != cp.getSshPortNumber() || !this.compareTextFields(orig.sshUserName, res.sshUserName, cp.sshUserName)) continue;
            res = cp;
        }
        return res;
    }

    private boolean comparePorts(int orig, int res, int test) {
        return orig == test && orig != res;
    }

    private boolean compareTextFields(String orig, String res, String test) {
        return orig != null && test != null && res != null && orig.equals(test) && !orig.equals(res);
    }

    public boolean isEmpty() {
        return this.connections.isEmpty();
    }
}

