/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.mac;

import com.glavsoft.exceptions.CommonException;
import com.glavsoft.utils.LazyLoaded;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MacApplicationWrapper {
    private final Object applicationInstance;
    private static final LazyLoaded<Class<?>> applicationClass = new LazyLoaded(new LazyLoaded.Loader<Class<?>>(){

        @Override
        public Class<?> load() throws ClassNotFoundException {
            return Class.forName("com.apple.eawt.Application");
        }
    });
    private static final LazyLoaded<Method> getApplicationMethod = new LazyLoaded<Method>(new LazyLoaded.Loader<Method>(){

        @Override
        public Method load() throws NoSuchMethodException {
            return applicationClass.get().getMethod("getApplication", new Class[0]);
        }
    });
    private static final LazyLoaded<Method> setDockIconImageMethod = new LazyLoaded<Method>(new LazyLoaded.Loader<Method>(){

        @Override
        public Method load() throws Throwable {
            return applicationClass.get().getMethod("setDockIconImage", Image.class);
        }
    });
    private static final LazyLoaded<Method> setEnabledAboutMenuMethod = new LazyLoaded<Method>(new LazyLoaded.Loader<Method>(){

        @Override
        public Method load() throws Throwable {
            return applicationClass.get().getMethod("setEnabledAboutMenu", Boolean.TYPE);
        }
    });

    private MacApplicationWrapper(Object applicationInstance) {
        this.applicationInstance = applicationInstance;
    }

    public static MacApplicationWrapper getApplication() throws CommonException {
        try {
            return new MacApplicationWrapper(getApplicationMethod.get().invoke(null, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw new CommonException("Cannot invoke com.apple.eawt.Application.getApplication: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CommonException("Cannot invoke com.apple.eawt.Application.getApplication: " + e.getMessage());
        }
    }

    public void setDockIconImage(Image icon) throws CommonException {
        if (null == icon) {
            throw new CommonException("Icon null");
        }
        try {
            setDockIconImageMethod.get().invoke(this.applicationInstance, icon);
        }
        catch (IllegalAccessException e) {
            throw new CommonException("Cannot invoke com.apple.eawt.Application.setDockIconImage: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CommonException("Cannot invoke com.apple.eawt.Application.setDockIconImage: " + e.getMessage());
        }
    }

    public void setEnabledAboutMenu(boolean enable) throws CommonException {
        try {
            setEnabledAboutMenuMethod.get().invoke(this.applicationInstance, enable);
        }
        catch (IllegalAccessException e) {
            throw new CommonException("Cannot invoke com.apple.eawt.Application.setEnabledAboutMenu: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CommonException("Cannot invoke com.apple.eawt.Application.setEnabledAboutMenu: " + e.getMessage());
        }
    }
}

