/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.ssh;

import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.settings.ConnectionParams;
import com.glavsoft.viewer.swing.CancelConnectionException;
import com.glavsoft.viewer.swing.CancelConnectionQuietlyException;
import com.glavsoft.viewer.swing.ConnectionErrorException;
import com.glavsoft.viewer.swing.gui.RequestSomethingDialog;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public abstract class SshConnectionManager {
    static final String SSH_NODE = "com/glavsoft/viewer/ssh";
    static final String KNOWN_HOSTS = "known_hosts";
    private static final String[] PRIV_KEY_FILE_NAMES = new String[]{"id_rsa", "id_dsa", "identity"};
    static final String OPENSSH_CONFIG_DIR_NAME = System.getProperty("user.home") + File.separator + ".ssh";
    private static final String SSH_CONNECTION_MANAGER_IMPLEMENTATION_CLASS_NAME = "com.glavsoft.viewer.swing.ssh.TrileadSsh2ConnectionManager";
    private static final String SSH_LIB_SOME_CLASS_NAME_FOR_CHECKING = "com.trilead.ssh2.Connection";
    String errorMessage = "";
    Component parent;
    protected Logger logger;

    SshConnectionManager(Component parent) {
        this.parent = parent;
    }

    public static SshConnectionManager createManager(Component parentWindow) throws ConnectionErrorException {
        try {
            Class<?> managerClass = Class.forName(SSH_CONNECTION_MANAGER_IMPLEMENTATION_CLASS_NAME);
            Constructor<?> constructor = managerClass.getConstructor(JFrame.class);
            return (SshConnectionManager)constructor.newInstance(parentWindow);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ReflectiveOperationException ex = e;
            Logger.getLogger(SshConnectionManager.class.getName()).log(Level.WARNING, "Could not instantiate SshConnectionManager, internal error : " + ex.getMessage(), ex);
            throw new ConnectionErrorException("Could not create SSH tunnel: internal error.");
        }
    }

    public int connect(ConnectionParams connectionParams) throws CancelConnectionException, ConnectionErrorException {
        if (Strings.isTrimmedEmpty(connectionParams.sshUserName)) {
            RequestSomethingDialog dialog = new RequestSomethingDialog(this.parent, "SSH User Name", false, "Please enter the user name for SSH connection:");
            if (!dialog.askResult()) {
                throw new CancelConnectionQuietlyException("Login interrupted by user");
            }
            connectionParams.sshUserName = dialog.getResult();
            if (Strings.isTrimmedEmpty(connectionParams.sshUserName)) {
                throw new CancelConnectionException("No Ssh User Name entered");
            }
        }
        this.initSshEngine();
        this.addIdentityFiles();
        return this.makeConnectionAndGetPort(connectionParams);
    }

    protected abstract void initSshEngine();

    protected abstract int makeConnectionAndGetPort(ConnectionParams var1) throws CancelConnectionException, ConnectionErrorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isKeyFileEncrypted(File keyFile) {
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(keyFile);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            if (line.startsWith("-----BEGIN ENCRYPTED PRIVATE KEY-----")) {
                boolean bl = true;
                return bl;
            }
            do {
                if ((line = reader.readLine()).indexOf(58) < 0) return false;
            } while (line.indexOf("ENCRYPTED") <= 0);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.logger.warning("Cannot read key file '" + keyFile.getName() + "': " + e.getMessage());
            return false;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addIdentityFiles() {
        for (String fileName : PRIV_KEY_FILE_NAMES) {
            File keyFile = new File(OPENSSH_CONFIG_DIR_NAME, fileName);
            if (!keyFile.exists() || !keyFile.isFile()) continue;
            this.addIdentityFile(keyFile);
        }
    }

    protected abstract void addIdentityFile(File var1);

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static boolean checkForSshSupport() {
        try {
            Class.forName(SSH_CONNECTION_MANAGER_IMPLEMENTATION_CLASS_NAME);
            Class.forName(SSH_LIB_SOME_CLASS_NAME_FOR_CHECKING);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public abstract boolean isConnected();

    public abstract void closeConnection();
}

