/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.ssh;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.settings.ConnectionParams;
import com.glavsoft.viewer.swing.CancelConnectionQuietlyException;
import com.glavsoft.viewer.swing.ConnectionErrorException;
import com.glavsoft.viewer.swing.gui.RequestSomethingDialog;
import com.glavsoft.viewer.swing.ssh.PrefsHelper;
import com.glavsoft.viewer.swing.ssh.RequestYesNoDialog;
import com.glavsoft.viewer.swing.ssh.SshConnectionManager;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.LocalPortForwarder;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.channel.LocalAcceptThread;
import com.trilead.ssh2.crypto.Base64;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class TrileadSsh2ConnectionManager
extends SshConnectionManager {
    private Set<File> identityFiles = new HashSet<File>();
    private LocalPortForwarder portForwarder;
    private boolean connected = false;
    private Connection connection;

    public TrileadSsh2ConnectionManager(JFrame parentWindow) {
        super(parentWindow);
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    protected void initSshEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int makeConnectionAndGetPort(ConnectionParams connectionParams) throws ConnectionErrorException {
        this.connected = false;
        int port = 0;
        this.connection = new Connection(connectionParams.getSshHostName(), connectionParams.getSshPortNumber());
        try {
            KnownHosts knownHosts = this.getKnownHosts();
            ConnectionInfo connectionInfo = this.connection.connect((ServerHostKeyVerifier)new HostVerifier(knownHosts));
            this.logger.fine("SSH connection established:\n  clientToServerCryptoAlgorithm: " + connectionInfo.clientToServerCryptoAlgorithm + "\n  clientToServerMACAlgorithm: " + connectionInfo.clientToServerMACAlgorithm + "\n  keyExchangeAlgorithm: " + connectionInfo.keyExchangeAlgorithm + "\n  serverHostKeyAlgorithm: " + connectionInfo.serverHostKeyAlgorithm + "\n  serverToClientCryptoAlgorithm: " + connectionInfo.serverToClientCryptoAlgorithm + "\n  serverToClientMACAlgorithm: " + connectionInfo.serverToClientMACAlgorithm);
            if (!this.connection.isAuthenticationComplete()) {
                this.tryAuthenticate(connectionParams, this.connection);
            }
            if (!this.connection.isAuthenticationComplete()) {
                throw new ConnectionErrorException("No supported authentication methods available.");
            }
            this.connection.setTCPNoDelay(true);
            this.portForwarder = this.connection.createLocalPortForwarder(port, connectionParams.getHostName(), connectionParams.getPortNumber());
            port = this.getPortNumber(this.portForwarder);
            this.connected = true;
        }
        catch (AuthenticationFailedException | CancelConnectionQuietlyException e) {
            this.logger.fine(e.getMessage());
            this.errorMessage = e.getMessage();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Cannot establish SSH connection: " + e.getMessage(), e);
            this.errorMessage = e.getMessage();
        }
        finally {
            if (!this.connected) {
                this.closeConnection();
            }
        }
        if (!this.connected) {
            throw new ConnectionErrorException("Cannot establish SSH connection: " + this.errorMessage);
        }
        return port;
    }

    @Override
    public void closeConnection() {
        if (this.portForwarder != null) {
            try {
                this.portForwarder.close();
                this.portForwarder = null;
            }
            catch (IOException e) {
                this.logger.warning("There was a problem while closing ssh port forwarder: " + e.getMessage());
            }
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.logger.fine("Close ssh connection");
    }

    private void tryAuthenticate(ConnectionParams connectionParams, Connection connection) throws Throwable {
        Object[] remainingAuthMethods = connection.getRemainingAuthMethods(connectionParams.getSshUserName());
        this.logger.finer("Supported auth methods: " + Arrays.toString(remainingAuthMethods));
        for (Object authMethod : remainingAuthMethods) {
            if ("publickey".equals(authMethod)) {
                for (File keyFile : this.identityFiles) {
                    this.logger.fine("Trying 'publickey' auth with " + String.valueOf(keyFile));
                    String passphrase = null;
                    if (this.isKeyFileEncrypted(keyFile)) {
                        String message;
                        String title;
                        if (keyFile.getName().contains("rsa")) {
                            title = "RSA Authentication";
                            message = "Enter RSA private key password:";
                        } else if (keyFile.getName().contains("dsa")) {
                            title = "DSA Authentication";
                            message = "Enter DSA private key password:";
                        } else {
                            title = "SSH Authentication";
                            message = "Enter private key password:";
                        }
                        passphrase = this.getPassphrase(title, message);
                    }
                    if (!connection.authenticateWithPublicKey(connectionParams.getSshUserName(), keyFile, passphrase)) continue;
                    this.logger.info("Authenticated with " + keyFile.getName());
                    return;
                }
            }
            if ("keyboard-interactive".equals(authMethod)) {
                this.logger.fine("Trying 'keyboard-interactive' auth");
                try {
                    if (connection.authenticateWithKeyboardInteractive(connectionParams.getSshUserName(), (InteractiveCallback)new InteractiveInputCallback())) {
                        return;
                    }
                    throw new AuthenticationFailedException("Authentication failed");
                }
                catch (IOException e) {
                    if (e.getCause() != null && e.getCause().getCause() != null) {
                        throw e.getCause().getCause();
                    }
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
            }
            if (!"password".equals(authMethod)) continue;
            this.logger.fine("Trying 'password' auth");
            if (connection.authenticateWithPassword(connectionParams.getSshUserName(), this.getPassphrase("Password Authentication", "Enter password for " + connectionParams.getSshUserName()))) {
                return;
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
    }

    private KnownHosts getKnownHosts() throws IOException {
        KnownHosts knownHosts = new KnownHosts();
        Preferences sshNode = Preferences.userRoot().node("com/glavsoft/viewer/ssh");
        try {
            knownHosts.addHostkeys(PrefsHelper.getStringFrom(sshNode, "known_hosts").toCharArray());
        }
        catch (IOException e) {
            PrefsHelper.clearNode(sshNode);
        }
        File knownHostsFile = new File(OPENSSH_CONFIG_DIR_NAME, "known_hosts");
        if (knownHostsFile.exists() && knownHostsFile.isFile()) {
            knownHosts.addHostkeys(knownHostsFile);
        }
        return knownHosts;
    }

    private String getPassphrase(String title, String message) {
        RequestSomethingDialog dialog = new RequestSomethingDialog(this.parent, title, true, message);
        return dialog.askResult() ? dialog.getResult() : "";
    }

    private int getPortNumber(LocalPortForwarder portForwarder) throws IOException {
        try {
            Field latField = portForwarder.getClass().getDeclaredField("lat");
            latField.setAccessible(true);
            LocalAcceptThread lat = (LocalAcceptThread)latField.get(portForwarder);
            Field ssField = lat.getClass().getDeclaredField("ss");
            ssField.setAccessible(true);
            return ((ServerSocket)ssField.get(lat)).getLocalPort();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.throwing(this.getClass().getName(), "getPortNumber(..)", e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void addIdentityFile(File keyFile) {
        this.identityFiles.add(keyFile);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    private class HostVerifier
    implements ServerHostKeyVerifier {
        private KnownHosts knownHosts;

        HostVerifier(KnownHosts knownHosts) {
            this.knownHosts = knownHosts;
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            String message;
            int result = this.knownHosts.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
            switch (result) {
                case 0: {
                    return true;
                }
                case 1: {
                    message = "Do you want to accept the hostkey (type " + serverHostKeyAlgorithm + ") from " + hostname + " ?";
                    break;
                }
                case 2: {
                    message = "WARNING! Hostkey for " + hostname + " has changed!\nAccept anyway?";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String hexFingerprint = KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            String bubblebabbleFingerprint = KnownHosts.createBubblebabbleFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            message = message + "\n\nHex Fingerprint: " + hexFingerprint + "\nBubblebabble Fingerprint: " + bubblebabbleFingerprint;
            RequestYesNoDialog yesNoDialog = new RequestYesNoDialog(TrileadSsh2ConnectionManager.this.parent, "SSH: Host Verification", message);
            boolean verified = yesNoDialog.ask();
            if (verified) {
                this.addHostkeyToStorages(hostname, serverHostKeyAlgorithm, serverHostKey);
            }
            return verified;
        }

        void addHostkeyToStorages(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
            Preferences sshNode = Preferences.userRoot().node("com/glavsoft/viewer/ssh");
            String record = hostname + " " + serverHostKeyAlgorithm + " " + new String(Base64.encode((byte[])serverHostKey));
            PrefsHelper.addRecordTo(sshNode, "known_hosts", record);
            KnownHosts.addHostkeyToFile((File)new File(SshConnectionManager.OPENSSH_CONFIG_DIR_NAME, "known_hosts"), (String[])new String[]{hostname}, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
        }
    }

    private class InteractiveInputCallback
    implements InteractiveCallback {
        private InteractiveInputCallback() {
        }

        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
            String[] answers = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                RequestSomethingDialog dialog = new RequestSomethingDialog(TrileadSsh2ConnectionManager.this.parent, "Keyboard Interactive Authentication", !echo[i], Strings.isTrimmedEmpty(name) ? "SSH Authentication" : name, null == instruction ? "" : instruction, prompt[i]).setOkLabel("Login");
                if (!dialog.askResult()) {
                    throw new CancelConnectionQuietlyException("Login interrupted by user");
                }
                answers[i] = dialog.getResult();
            }
            return answers;
        }
    }
}

