/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.sync;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.DeletedData;
import app.termora.ResponseException;
import app.termora.plugins.sync.GistResponse;
import app.termora.plugins.sync.PBKDF2;
import app.termora.plugins.sync.SafetySyncer;
import app.termora.plugins.sync.SyncConfig;
import app.termora.plugins.sync.SyncRange;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/sync/WebDAVSyncer;", "Lapp/termora/plugins/sync/SafetySyncer;", "<init>", "()V", "pull", "Lapp/termora/plugins/sync/GistResponse;", "config", "Lapp/termora/plugins/sync/SyncConfig;", "push", "getWebDavFileUrl", "", "getKey", "", "newRequestBuilder", "Lokhttp3/Request$Builder;", "Companion", "sync"})
@SourceDebugExtension(value={"SMAP\nWebDAVSyncer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebDAVSyncer.kt\napp/termora/plugins/sync/WebDAVSyncer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,201:1\n1#2:202\n222#3:203\n205#3:228\n774#4:204\n865#4,2:205\n774#4:207\n865#4,2:208\n774#4:210\n865#4,2:211\n774#4:213\n865#4,2:214\n774#4:216\n865#4,2:217\n774#4:219\n865#4,2:220\n774#4:222\n865#4,2:223\n29#5,3:225\n*S KotlinDebug\n*F\n+ 1 WebDAVSyncer.kt\napp/termora/plugins/sync/WebDAVSyncer\n*L\n41#1:203\n167#1:228\n48#1:204\n48#1:205,2\n51#1:207\n51#1:208,2\n58#1:210\n58#1:211,2\n65#1:213\n65#1:214,2\n72#1:216\n72#1:217,2\n79#1:219\n79#1:220,2\n86#1:222\n86#1:223,2\n96#1:225,3\n*E\n"})
public final class WebDAVSyncer
extends SafetySyncer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(WebDAVSyncer.class);

    private WebDAVSyncer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GistResponse pull(@NotNull SyncConfig config) {
        block36: {
            List list;
            DeletedData e;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            WebDAVSyncer webDAVSyncer;
            Object object;
            Object it;
            void this_$iv;
            Response response;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Response response2 = this.getHttpClient().newCall(this.newRequestBuilder(config).get().build()).execute();
            if (!response2.isSuccessful()) {
                IOUtils.closeQuietly((Closeable)((Closeable)response2));
                if (response2.code() == 404) {
                    return new GistResponse(config, CollectionsKt.emptyList());
                }
                throw new ResponseException(response2.code(), response2);
            }
            Closeable closeable = (Closeable)response2;
            Throwable throwable = null;
            try {
                Object object2;
                Response resp = (Response)closeable;
                boolean bl = false;
                ResponseBody responseBody = resp.body();
                if (responseBody != null) {
                    Closeable closeable2 = (Closeable)responseBody;
                    Throwable throwable2 = null;
                    try {
                        Object it2 = (ResponseBody)closeable2;
                        boolean bl2 = false;
                        it2 = it2.string();
                        object2 = it2;
                    }
                    catch (Throwable bl2) {
                        throwable2 = bl2;
                        throw bl2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                } else {
                    object2 = null;
                }
                resp = object2;
                response = resp;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (response == null) {
                throw new ResponseException(response2.code(), response2);
            }
            Response text = response;
            closeable = Application.INSTANCE.getOhMyJson();
            Response string$iv = text;
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv.getSerializersModule();
            KType kType = Reflection.typeOf(JsonObject.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            JsonObject json = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (String)string$iv);
            List deletedData = new ArrayList();
            Object object3 = (JsonElement)json.get((Object)"DeletedData");
            if (object3 != null && (object3 = JsonElementKt.getJsonPrimitive((JsonElement)object3)) != null && (object3 = object3.getContent()) != null) {
                it = object3;
                boolean bl = false;
                deletedData.addAll((Collection)this.decodeDeletedData((String)it, config));
            }
            if (config.getRanges().contains((Object)SyncRange.Hosts)) {
                Object object4;
                Object object5 = (JsonElement)json.get((Object)"Tags");
                if (object5 != null && (object5 = JsonElementKt.getJsonPrimitive((JsonElement)object5)) != null && (object5 = object5.getContent()) != null) {
                    void $this$filter$iv;
                    it = object5;
                    boolean bl = false;
                    Iterable bl2 = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    void var16_37 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Tags")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeTags((String)object, list, config);
                }
                if ((object4 = (JsonElement)json.get((Object)"Hosts")) != null && (object4 = JsonElementKt.getJsonPrimitive((JsonElement)object4)) != null && (object4 = object4.getContent()) != null) {
                    it = object4;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Host")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeHosts((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.KeyPairs)) {
                Object object6 = (JsonElement)json.get((Object)"KeyPairs");
                if (object6 != null && (object6 = JsonElementKt.getJsonPrimitive((JsonElement)object6)) != null && (object6 = object6.getContent()) != null) {
                    it = object6;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"KeyPair")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeKeys((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.KeywordHighlights)) {
                Object object7 = (JsonElement)json.get((Object)"KeywordHighlights");
                if (object7 != null && (object7 = JsonElementKt.getJsonPrimitive((JsonElement)object7)) != null && (object7 = object7.getContent()) != null) {
                    it = object7;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"KeywordHighlight")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeKeywordHighlights((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.Macros)) {
                Object object8 = (JsonElement)json.get((Object)"Macros");
                if (object8 != null && (object8 = JsonElementKt.getJsonPrimitive((JsonElement)object8)) != null && (object8 = object8.getContent()) != null) {
                    it = object8;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Macro")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeMacros((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.Keymap)) {
                Object object9 = (JsonElement)json.get((Object)"Keymaps");
                if (object9 != null && (object9 = JsonElementKt.getJsonPrimitive((JsonElement)object9)) != null && (object9 = object9.getContent()) != null) {
                    it = object9;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Keymap")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeKeymaps((String)object, list, config);
                }
            }
            if (!config.getRanges().contains((Object)SyncRange.Snippets)) break block36;
            Object object10 = (JsonElement)json.get((Object)"Snippets");
            if (object10 != null && (object10 = JsonElementKt.getJsonPrimitive((JsonElement)object10)) != null && (object10 = object10.getContent()) != null) {
                it = object10;
                boolean bl = false;
                Iterable $this$filter$iv = deletedData;
                object = it;
                webDAVSyncer = this;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    e = (DeletedData)element$iv$iv;
                    boolean bl9 = false;
                    if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Snippet")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                webDAVSyncer.decodeSnippets((String)object, list, config);
            }
        }
        return new GistResponse(config, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GistResponse push(@NotNull SyncConfig config) {
        void this_$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$push_u24lambda_u2417 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        if (config.getRanges().contains((Object)SyncRange.Hosts)) {
            String hostsContent = this.encodeHosts(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedHosts: {}", (Object)hostsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"Hosts", (String)hostsContent);
            String tagsContent = this.encodeTags(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedTags: {}", (Object)tagsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"Tags", (String)tagsContent);
        }
        if (config.getRanges().contains((Object)SyncRange.Snippets)) {
            String snippetsContent = this.encodeSnippets(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedSnippets: {}", (Object)snippetsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"Snippets", (String)snippetsContent);
        }
        if (config.getRanges().contains((Object)SyncRange.KeyPairs)) {
            String keysContent = this.encodeKeys(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedKeys: {}", (Object)keysContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"KeyPairs", (String)keysContent);
        }
        if (config.getRanges().contains((Object)SyncRange.KeywordHighlights)) {
            String keywordHighlightsContent = this.encodeKeywordHighlights(key);
            if (log.isDebugEnabled()) {
                log.debug("Push keywordHighlights: {}", (Object)keywordHighlightsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"KeywordHighlights", (String)keywordHighlightsContent);
        }
        if (config.getRanges().contains((Object)SyncRange.Macros)) {
            String macrosContent = this.encodeMacros(key);
            if (log.isDebugEnabled()) {
                log.debug("Push macros: {}", (Object)macrosContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"Macros", (String)macrosContent);
        }
        if (config.getRanges().contains((Object)SyncRange.Keymap)) {
            String keymapsContent = this.encodeKeymaps();
            if (log.isDebugEnabled()) {
                log.debug("Push keymaps: {}", (Object)keymapsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"Keymaps", (String)keymapsContent);
        }
        String deletedData = this.encodeDeletedData(config);
        if (log.isDebugEnabled()) {
            log.debug("Push DeletedData: {}", (Object)deletedData);
        }
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2417, (String)"DeletedData", (String)deletedData);
        JsonObject json = builder$iv.build();
        OkHttpClient okHttpClient = this.getHttpClient();
        Request.Builder builder = this.newRequestBuilder(config);
        builder$iv = Application.INSTANCE.getOhMyJson();
        JsonObject value$iv = json;
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        Response response = okHttpClient.newCall(builder.put(RequestBody.Companion.create(this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)value$iv), MediaType.Companion.get("application/json"))).build()).execute();
        if (!response.isSuccessful()) {
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            throw new ResponseException(response.code(), response);
        }
        return new GistResponse(config, CollectionsKt.emptyList());
    }

    private final String getWebDavFileUrl(SyncConfig config) {
        String string = config.getOptions().get("domain");
        if (string == null) {
            throw new IllegalStateException("domain is not defined");
        }
        return string;
    }

    @Override
    @NotNull
    protected byte[] getKey(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        char[] cArray = config.getGistId().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        String string = config.getToken();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return PBKDF2.INSTANCE.generateSecret(cArray, byArray, 10000, 128);
    }

    private final Request.Builder newRequestBuilder(SyncConfig config) {
        return new Request.Builder().header("Authorization", Credentials.basic((String)config.getGistId(), (String)config.getToken(), (Charset)Charsets.UTF_8)).url(this.getWebDavFileUrl(config));
    }

    public /* synthetic */ WebDAVSyncer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/sync/WebDAVSyncer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/plugins/sync/WebDAVSyncer;", "sync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebDAVSyncer getInstance() {
            return (WebDAVSyncer)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(WebDAVSyncer.class), Companion::getInstance$lambda$0);
        }

        private static final WebDAVSyncer getInstance$lambda$0() {
            return new WebDAVSyncer(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

