/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.editor;

import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.EnableManager;
import app.termora.OptionPane;
import app.termora.plugins.editor.EditorI18n;
import app.termora.plugins.editor.EditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/plugins/editor/EditorFrame;", "Ljavax/swing/JFrame;", "file", "Ljava/nio/file/Path;", "owner", "Ljava/awt/Window;", "disposable", "Lapp/termora/Disposable;", "<init>", "(Ljava/nio/file/Path;Ljava/awt/Window;Lapp/termora/Disposable;)V", "enableManager", "Lapp/termora/EnableManager;", "getEnableManager", "()Lapp/termora/EnableManager;", "disposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "filepath", "Ljava/io/File;", "frame", "getFrame", "()Lapp/termora/plugins/editor/EditorFrame;", "editorPanel", "Lapp/termora/plugins/editor/EditorPanel;", "initEvent", "", "initView", "editor"})
public final class EditorFrame
extends JFrame {
    @NotNull
    private final Path file;
    @NotNull
    private final Window owner;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final AtomicBoolean disposed;
    @NotNull
    private final File filepath;
    @NotNull
    private final EditorPanel editorPanel;

    public EditorFrame(@NotNull Path file, @NotNull Window owner, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.file = file;
        this.owner = owner;
        this.disposable = disposable;
        this.disposed = new AtomicBoolean();
        this.filepath = new File(((Object)this.file.toAbsolutePath()).toString());
        this.editorPanel = new EditorPanel(this, this.filepath);
        this.initView();
        this.initEvent();
    }

    private final EnableManager getEnableManager() {
        return EnableManager.Companion.getInstance();
    }

    private final EditorFrame getFrame() {
        return this;
    }

    private final void initEvent() {
        Disposer.register((Disposable)this.disposable, (Disposable)new Disposable(this){
            final /* synthetic */ EditorFrame this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                if (EditorFrame.access$getDisposed$p(this.this$0).compareAndSet(false, true)) {
                    EditorFrame.access$getFrame(this.this$0).dispose();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ EditorFrame this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosed(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (EditorFrame.access$getDisposed$p(this.this$0).compareAndSet(false, true)) {
                    Disposer.dispose((Disposable)EditorFrame.access$getDisposable$p(this.this$0));
                }
                EditorFrame.access$getEnableManager(this.this$0).setFlag("Plugins.editor.dialog.width", this.this$0.getWidth());
                EditorFrame.access$getEnableManager(this.this$0).setFlag("Plugins.editor.dialog.height", this.this$0.getHeight());
                EditorFrame.access$getEnableManager(this.this$0).setFlag("Plugins.editor.dialog.extendedState", this.this$0.getExtendedState());
            }

            public void windowClosing(WindowEvent e) {
                if (EditorFrame.access$getEditorPanel$p(this.this$0).changes()) {
                    if (OptionPane.showConfirmDialog$default((OptionPane)OptionPane.INSTANCE, (Component)EditorFrame.access$getFrame(this.this$0), (Object)EditorI18n.INSTANCE.getString("termora.plugins.editor.not-save"), null, (int)2, (int)0, null, null, null, null, (int)500, null) == 0) {
                        EditorFrame.access$getFrame(this.this$0).dispose();
                    }
                } else {
                    EditorFrame.access$getFrame(this.this$0).dispose();
                }
            }
        });
    }

    private final void initView() {
        this.setSize(new Dimension(UIManager.getInt("Dialog.width"), UIManager.getInt("Dialog.height")));
        int state = this.getEnableManager().getFlag("Plugins.editor.dialog.extendedState", 0);
        if ((state & 6) == 6) {
            this.getFrame().setLocationRelativeTo(null);
            this.getFrame().setExtendedState(state);
        } else {
            Dimension mySize = this.getSize();
            mySize.width = Math.max(this.getEnableManager().getFlag("Plugins.editor.dialog.width", mySize.width), mySize.width);
            mySize.height = Math.max(this.getEnableManager().getFlag("Plugins.editor.dialog.height", mySize.height), mySize.height);
            this.setSize(mySize);
            this.setLocationRelativeTo(this.owner);
        }
        this.setTitle(PathsKt.getName((Path)this.file));
        this.setIconImages(this.owner.getIconImages());
        this.setDefaultCloseOperation(0);
        this.rootPane.getContentPane().setLayout(new BorderLayout());
        this.rootPane.getContentPane().add((Component)this.editorPanel, "Center");
    }

    public static final /* synthetic */ AtomicBoolean access$getDisposed$p(EditorFrame $this) {
        return $this.disposed;
    }

    public static final /* synthetic */ EditorFrame access$getFrame(EditorFrame $this) {
        return $this.getFrame();
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(EditorFrame $this) {
        return $this.disposable;
    }

    public static final /* synthetic */ EnableManager access$getEnableManager(EditorFrame $this) {
        return $this.getEnableManager();
    }

    public static final /* synthetic */ EditorPanel access$getEditorPanel$p(EditorFrame $this) {
        return $this.editorPanel;
    }
}

