/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.File;
import java.io.IOException;
import org.fife.rsta.ac.java.PackageMapNode;
import org.fife.rsta.ac.java.buildpath.JarLibraryInfo;
import org.fife.rsta.ac.java.buildpath.Jdk9LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.buildpath.ZipSourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public abstract class LibraryInfo
implements Comparable<LibraryInfo>,
Cloneable {
    private static final System.Logger LOG = System.getLogger(LibraryInfo.class.getName());
    private SourceLocation sourceLoc;

    public abstract void bulkClassFileCreationEnd() throws IOException;

    public abstract void bulkClassFileCreationStart() throws IOException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException("Doesn't support cloning, but should! - " + this.getClass().getName());
        }
    }

    public abstract ClassFile createClassFile(String var1) throws IOException;

    public abstract ClassFile createClassFileBulk(String var1) throws IOException;

    public abstract PackageMapNode createPackageMap() throws IOException;

    public boolean equals(Object o) {
        return o instanceof LibraryInfo && this.compareTo((LibraryInfo)o) == 0;
    }

    public static LibraryInfo getJreJarInfo(File jreHome) {
        File sourceZip;
        File mods = new File(jreHome, "jmods");
        if (mods.isDirectory()) {
            File[] files = mods.listFiles(pathname -> {
                if (pathname.isFile()) {
                    String name = pathname.getName();
                    return name.endsWith(".jmod") && (name.startsWith("java.") || name.startsWith("jdk."));
                }
                return false;
            });
            Jdk9LibraryInfo info = new Jdk9LibraryInfo(files);
            File sourceZip2 = new File(jreHome, "lib/src.zip");
            if (sourceZip2.isFile()) {
                info.setSourceLocation(new ZipSourceLocation(sourceZip2));
            }
            return info;
        }
        JarLibraryInfo info = null;
        File mainJar = new File(jreHome, "lib/rt.jar");
        if (mainJar.isFile()) {
            sourceZip = new File(jreHome, "src.zip");
            if (!sourceZip.isFile()) {
                sourceZip = new File(jreHome, "../src.zip");
            }
        } else {
            mainJar = new File(jreHome, "../Classes/classes.jar");
            sourceZip = new File(jreHome, "src.jar");
        }
        if (mainJar.isFile()) {
            info = new JarLibraryInfo(mainJar);
            if (sourceZip.isFile()) {
                info.setSourceLocation(new ZipSourceLocation(sourceZip));
            }
        } else {
            LOG.log(System.Logger.Level.ERROR, "Cannot locate JRE jar in " + jreHome.getAbsolutePath());
            mainJar = null;
        }
        return info;
    }

    public abstract long getLastModified();

    public abstract String getLocationAsString();

    public static LibraryInfo getMainJreJarInfo() {
        String javaHome = System.getProperty("java.home");
        return LibraryInfo.getJreJarInfo(new File(javaHome));
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    public int hashCode() {
        return this.hashCodeImpl();
    }

    public abstract int hashCodeImpl();

    public void setSourceLocation(SourceLocation sourceLoc) {
        this.sourceLoc = sourceLoc;
    }
}

