/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.js.ast;

import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.js.ast.JavaScriptVariableDeclaration;

public class CodeBlock {
    private static final System.Logger LOG = System.getLogger(CodeBlock.class.getName());
    private int start;
    private int end;
    private CodeBlock parent;
    private List<CodeBlock> children;
    private List<JavaScriptVariableDeclaration> varDeclarations;

    public CodeBlock(int start) {
        this.start = start;
        this.end = Integer.MAX_VALUE;
    }

    public CodeBlock addChildCodeBlock(int start) {
        CodeBlock child = new CodeBlock(start);
        child.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<CodeBlock>();
        }
        this.children.add(child);
        return child;
    }

    public void addVariable(JavaScriptVariableDeclaration varDec) {
        if (this.varDeclarations == null) {
            this.varDeclarations = new ArrayList<JavaScriptVariableDeclaration>();
        }
        this.varDeclarations.add(varDec);
    }

    public boolean contains(int offset) {
        return offset >= this.start && offset < this.end;
    }

    public CodeBlock getChildCodeBlock(int index) {
        return this.children.get(index);
    }

    public int getChildCodeBlockCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public int getEndOffset() {
        return this.end;
    }

    public CodeBlock getParent() {
        return this.parent;
    }

    public int getStartOffset() {
        return this.start;
    }

    public JavaScriptVariableDeclaration getVariableDeclaration(int index) {
        return this.varDeclarations.get(index);
    }

    public int getVariableDeclarationCount() {
        return this.varDeclarations == null ? 0 : this.varDeclarations.size();
    }

    public void setEndOffset(int end) {
        this.end = end;
    }

    public void setStartOffSet(int start) {
        this.start = start;
    }

    public void debug() {
        StringBuilder sb = new StringBuilder();
        this.outputChild(sb, this, 0);
        LOG.log(System.Logger.Level.DEBUG, sb.toString());
    }

    private void outputChild(StringBuilder sb, CodeBlock block, int tab) {
        StringBuilder tabs = new StringBuilder();
        tabs.append("\t".repeat(Math.max(0, tab)));
        sb.append((CharSequence)tabs);
        sb.append("start: ").append(block.getStartOffset()).append("\n");
        sb.append((CharSequence)tabs);
        sb.append("end: ").append(block.getEndOffset()).append("\n");
        sb.append((CharSequence)tabs);
        sb.append("var count: ").append(block.getVariableDeclarationCount()).append("\n").append("\n");
        for (int i = 0; i < block.getChildCodeBlockCount(); ++i) {
            CodeBlock childBlock = block.getChildCodeBlock(i);
            this.outputChild(sb, childBlock, tab++);
        }
    }
}

