/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.serial;

import app.termora.terminal.PtyConnector;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.nio.charset.Charset;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lapp/termora/plugins/serial/SerialPortPtyConnector;", "Lapp/termora/terminal/PtyConnector;", "Lcom/fazecast/jSerialComm/SerialPortDataListener;", "serialPort", "Lcom/fazecast/jSerialComm/SerialPort;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Lcom/fazecast/jSerialComm/SerialPort;Ljava/nio/charset/Charset;)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "read", "", "buffer", "", "write", "", "", "offset", "len", "resize", "rows", "cols", "waitFor", "close", "getListeningEvents", "serialEvent", "event", "Lcom/fazecast/jSerialComm/SerialPortEvent;", "getCharset", "serial"})
public final class SerialPortPtyConnector
implements PtyConnector,
SerialPortDataListener {
    @NotNull
    private final SerialPort serialPort;
    @NotNull
    private final Charset charset;
    @NotNull
    private final LinkedBlockingQueue<Character> queue;

    public SerialPortPtyConnector(@NotNull SerialPort serialPort, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)serialPort, (String)"serialPort");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.serialPort = serialPort;
        this.charset = charset;
        this.queue = new LinkedBlockingQueue();
        this.serialPort.addDataListener((SerialPortDataListener)this);
    }

    public /* synthetic */ SerialPortPtyConnector(SerialPort serialPort, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(serialPort, charset);
    }

    public int read(@NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Character c = this.queue.poll(1L, TimeUnit.SECONDS);
        if (c == null) {
            return 0;
        }
        buffer[0] = c.charValue();
        return 1;
    }

    public void write(@NotNull byte[] buffer, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.serialPort.writeBytes(buffer, len, offset);
    }

    public void resize(int rows, int cols) {
    }

    public int waitFor() {
        return 0;
    }

    public void close() {
        this.queue.clear();
        this.serialPort.closePort();
    }

    public int getListeningEvents() {
        return 16;
    }

    public void serialEvent(@NotNull SerialPortEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEventType() == 16) {
            byte[] data = event.getReceivedData();
            Intrinsics.checkNotNull((Object)data);
            if (data.length == 0) {
                return;
            }
            char[] cArray = new String(data, this.charset).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            for (char c : cArray) {
                this.queue.add(Character.valueOf(c));
            }
        }
    }

    @NotNull
    public Charset getCharset() {
        return this.charset;
    }

    public void write(@NotNull byte[] buffer) {
        super.write(buffer);
    }

    public void write(int buffer) {
        super.write(buffer);
    }
}

