/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.bg;

import app.termora.Application;
import app.termora.ApplicationRunnerExtension;
import app.termora.ApplicationScope;
import app.termora.CryptoKt;
import app.termora.Disposable;
import app.termora.GlassPaneAwareExtension;
import app.termora.ScopeKt;
import app.termora.plugin.DispatchThread;
import app.termora.plugins.bg.Appearance;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010\u0013\u001a\u00020\u000fJ\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/termora/plugins/bg/BackgroundManager;", "Lapp/termora/Disposable;", "Lapp/termora/GlassPaneAwareExtension;", "Lapp/termora/ApplicationRunnerExtension;", "<init>", "()V", "bufferedImage", "Ljava/awt/image/BufferedImage;", "imageFilepath", "", "glassPanes", "", "Ljava/lang/ref/WeakReference;", "Ljavax/swing/JComponent;", "setBackgroundImage", "", "url", "getBackgroundImage", "doGetBackgroundImage", "clearBackgroundImage", "refreshBackgroundImage", "refreshGlassPanes", "dispose", "setGlassPane", "window", "Ljava/awt/Window;", "glassPane", "ready", "Companion", "bg"})
@SourceDebugExtension(value={"SMAP\nBackgroundManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundManager.kt\napp/termora/plugins/bg/BackgroundManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class BackgroundManager
implements Disposable,
GlassPaneAwareExtension,
ApplicationRunnerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferedImage bufferedImage;
    @NotNull
    private String imageFilepath = "";
    @NotNull
    private final List<WeakReference<JComponent>> glassPanes = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(BackgroundManager.class);

    private BackgroundManager() {
    }

    public final void setBackgroundImage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.clearBackgroundImage();
        Appearance.INSTANCE.setBackgroundImage(url);
        this.refreshBackgroundImage();
    }

    @Nullable
    public final BufferedImage getBackgroundImage() {
        BufferedImage bg = this.doGetBackgroundImage();
        if (bg == null) {
            if (JPopupMenu.getDefaultLightWeightPopupEnabled()) {
                return null;
            }
            JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        } else if (JPopupMenu.getDefaultLightWeightPopupEnabled()) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }
        return bg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedImage doGetBackgroundImage() {
        BackgroundManager backgroundManager = this;
        synchronized (backgroundManager) {
            boolean bl = false;
            BufferedImage bufferedImage = this.bufferedImage;
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBackgroundImage() {
        BackgroundManager backgroundManager = this;
        synchronized (backgroundManager) {
            boolean bl = false;
            this.bufferedImage = null;
            this.imageFilepath = "";
            Appearance.INSTANCE.setBackgroundImage("");
            Unit unit = Unit.INSTANCE;
        }
        this.refreshGlassPanes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshBackgroundImage() {
        BufferedImage bufferedImage;
        File backgroundImageFile;
        int n;
        Object response;
        Object object;
        String backgroundImage = Appearance.INSTANCE.getBackgroundImage();
        if (StringsKt.isBlank((CharSequence)backgroundImage)) {
            return;
        }
        File file = null;
        if (StringsKt.startsWith$default((String)backgroundImage, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)backgroundImage, (String)"https://", (boolean)false, (int)2, null)) {
            Closeable closeable = (Closeable)Application.INSTANCE.getHttpClient().newCall(new Request.Builder().get().url(backgroundImage).build()).execute();
            object = null;
            try {
                response = (Response)closeable;
                n = 0;
                File tempFile = new File(Application.INSTANCE.getTemporaryDir(), CryptoKt.randomUUID());
                if (!response.isSuccessful()) {
                    if (log.isErrorEnabled()) {
                        log.error("Request {} failed with code {}", (Object)backgroundImage, (Object)response.code());
                    }
                    return;
                }
                ResponseBody body = response.body();
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable2;
                    boolean bl = false;
                    int n2 = IOUtils.copy((InputStream)body.byteStream(), (OutputStream)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                IOUtils.closeQuietly((Closeable)((Closeable)body));
                response = tempFile;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            file = response;
        }
        if ((backgroundImageFile = new File(backgroundImage)).isDirectory()) {
            response = new Response[]{"png", "jpg", "jpeg"};
            Collection files = FileUtils.listFiles((File)backgroundImageFile, (String[])response, (boolean)false);
            Intrinsics.checkNotNull((Object)files);
            if (!files.isEmpty()) {
                n = files.size();
                for (int i = 0; i < n && (file = (File)CollectionsKt.randomOrNull((Collection)files, (Random)((Random)Random.Default))) != null; ++i) {
                    if (!Intrinsics.areEqual((Object)file.getAbsolutePath(), (Object)this.imageFilepath)) continue;
                }
            } else {
                BackgroundManager backgroundManager = this;
                synchronized (backgroundManager) {
                    boolean $i$a$-synchronized-BackgroundManager$refreshBackgroundImage$32 = false;
                    this.imageFilepath = "";
                    this.bufferedImage = null;
                    this.refreshGlassPanes();
                    Unit $i$a$-synchronized-BackgroundManager$refreshBackgroundImage$32 = Unit.INSTANCE;
                }
            }
        } else if (backgroundImageFile.isFile()) {
            file = backgroundImageFile;
        }
        if (file == null || Intrinsics.areEqual((Object)this.imageFilepath, (Object)file.getAbsolutePath())) {
            return;
        }
        object = file;
        object = new FileInputStream((File)object);
        BackgroundManager backgroundManager = this;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl = false;
            bufferedImage = ImageIO.read(it);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        backgroundManager.bufferedImage = bufferedImage;
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.imageFilepath = string;
        this.refreshGlassPanes();
    }

    private final void refreshGlassPanes() {
        SwingUtilities.invokeLater(() -> BackgroundManager.refreshGlassPanes$lambda$8(this));
    }

    public void dispose() {
    }

    public void setGlassPane(@NotNull Window window, @NotNull JComponent glassPane) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        this.glassPanes.add(new WeakReference<JComponent>(glassPane));
    }

    public void ready() {
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BackgroundManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            var3_4 = $this$launch;
                            var4_5 = this.this$0;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = var3_4;
                                $i$a$-runCatching-BackgroundManager$ready$1$1 = false;
                                BackgroundManager.access$refreshBackgroundImage((BackgroundManager)var4_5);
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable $i$a$-runCatching-BackgroundManager$ready$1$1) {
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-BackgroundManager$ready$1$1));
                            }
                            var3_4 = $this$invokeSuspend_u24lambda_u240;
                            v0 = Result.exceptionOrNull-impl((Object)var3_4);
                            if (v0 != null) {
                                it = var4_5 = v0;
                                $i$a$-onFailure-BackgroundManager$ready$1$2 = false;
                                if (BackgroundManager.access$getLog$cp().isErrorEnabled()) {
                                    BackgroundManager.access$getLog$cp().error("Refresh failed", (Throwable)it);
                                }
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)Math.max(Appearance.INSTANCE.getInterval(), 30), (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v1 != var7_3) continue;
                            return var7_3;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public long ordered() {
        return super.ordered();
    }

    @NotNull
    public DispatchThread getDispatchThread() {
        return super.getDispatchThread();
    }

    private static final boolean refreshGlassPanes$lambda$8$lambda$6(WeakReference it) {
        JComponent glassPane;
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JComponent jComponent = glassPane = (JComponent)it.get();
            if (jComponent == null) break block0;
            jComponent.repaint();
        }
        return glassPane == null;
    }

    private static final boolean refreshGlassPanes$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void refreshGlassPanes$lambda$8(BackgroundManager this$0) {
        this$0.glassPanes.removeIf(arg_0 -> BackgroundManager.refreshGlassPanes$lambda$8$lambda$7(BackgroundManager::refreshGlassPanes$lambda$8$lambda$6, arg_0));
    }

    public /* synthetic */ BackgroundManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ void access$refreshBackgroundImage(BackgroundManager $this) {
        $this.refreshBackgroundImage();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/bg/BackgroundManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/plugins/bg/BackgroundManager;", "bg"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackgroundManager getInstance() {
            return (BackgroundManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(BackgroundManager.class), Companion::getInstance$lambda$0);
        }

        private static final BackgroundManager getInstance$lambda$0() {
            return new BackgroundManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

