/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.util.Stack;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.classreader.attributes.Code;

public class Frame {
    private static final System.Logger LOG = System.getLogger(Frame.class.getName());
    private Stack<String> operandStack = new Stack();
    private LocalVarInfo[] localVars;

    public Frame(Code code) {
        this.localVars = new LocalVarInfo[code.getMaxLocals()];
        int i = 0;
        MethodInfo mi = code.getMethodInfo();
        if (!mi.isStatic()) {
            this.localVars[i++] = new LocalVarInfo("this", true);
        }
        String[] paramTypes = mi.getParameterTypes();
        for (int paramI = 0; paramI < paramTypes.length; ++paramI) {
            String type = paramTypes[paramI];
            if (type.indexOf(46) > -1) {
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            String name = "localVar_" + type + "_" + paramI;
            this.localVars[i] = new LocalVarInfo(name, true);
            ++i;
            if (!"long".equals(type) && !"double".equals(type)) continue;
            ++i;
        }
        LOG.log(System.Logger.Level.DEBUG, "NOTE: " + (this.localVars.length - i) + " unknown localVars slots");
    }

    public LocalVarInfo getLocalVar(int index, String defaultType) {
        LocalVarInfo var = this.localVars[index];
        if (var == null) {
            String name = "localVar_" + defaultType + "_" + index;
            this.localVars[index] = var = new LocalVarInfo(name, false);
        } else {
            var.alreadyDeclared = true;
        }
        return var;
    }

    public String pop() {
        return this.operandStack.pop();
    }

    public void push(String value) {
        this.operandStack.push(value);
    }

    public static class LocalVarInfo {
        private String value;
        private boolean alreadyDeclared;

        public LocalVarInfo(String value, boolean alreadyDeclared) {
            this.value = value;
            this.alreadyDeclared = alreadyDeclared;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isAlreadyDeclared() {
            return this.alreadyDeclared;
        }
    }
}

