/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.editor;

import app.termora.DocumentAdaptor;
import app.termora.DynamicColor;
import app.termora.DynamicIcon;
import app.termora.EnableManager;
import app.termora.Icons;
import app.termora.database.DatabaseManager;
import app.termora.plugins.editor.EditorI18n;
import app.termora.plugins.editor.EditorPlugin;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.components.FlatTextField;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\u0012\u0010+\u001a\u00020(2\b\b\u0002\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lapp/termora/plugins/editor/EditorPanel;", "Ljavax/swing/JPanel;", "window", "Ljavax/swing/JFrame;", "file", "Ljava/io/File;", "<init>", "(Ljavax/swing/JFrame;Ljava/io/File;)V", "text", "", "layeredPane", "Lapp/termora/plugins/editor/EditorPanel$LayeredPane;", "textArea", "Lorg/fife/ui/rsyntaxtextarea/RSyntaxTextArea;", "scrollPane", "Lorg/fife/ui/rtextarea/RTextScrollPane;", "findPanel", "Lcom/formdev/flatlaf/extras/components/FlatToolBar;", "toolbar", "searchTextField", "Lcom/formdev/flatlaf/extras/components/FlatTextField;", "closeFindPanelBtn", "Ljavax/swing/JButton;", "nextBtn", "prevBtn", "context", "Lorg/fife/ui/rtextarea/SearchContext;", "softWrapBtn", "Ljavax/swing/JToggleButton;", "saveBtn", "scrollUpBtn", "scrollEndBtn", "prettyBtn", "enableManager", "Lapp/termora/EnableManager;", "getEnableManager", "()Lapp/termora/EnableManager;", "prettyJson", "Lkotlinx/serialization/json/Json;", "initView", "", "initEvents", "format", "search", "searchForward", "", "changes", "Companion", "LayeredPane", "editor"})
@SourceDebugExtension(value={"SMAP\nEditorPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorPanel.kt\napp/termora/plugins/editor/EditorPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,345:1\n1#2:346\n205#3:347\n*S KotlinDebug\n*F\n+ 1 EditorPanel.kt\napp/termora/plugins/editor/EditorPanel\n*L\n273#1:347\n*E\n"})
public final class EditorPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JFrame window;
    @NotNull
    private final File file;
    @NotNull
    private String text;
    @NotNull
    private final LayeredPane layeredPane;
    @NotNull
    private final RSyntaxTextArea textArea;
    @NotNull
    private final RTextScrollPane scrollPane;
    @NotNull
    private final FlatToolBar findPanel;
    @NotNull
    private final FlatToolBar toolbar;
    @NotNull
    private final FlatTextField searchTextField;
    @NotNull
    private final JButton closeFindPanelBtn;
    @NotNull
    private final JButton nextBtn;
    @NotNull
    private final JButton prevBtn;
    @NotNull
    private final SearchContext context;
    @NotNull
    private final JToggleButton softWrapBtn;
    @NotNull
    private final JButton saveBtn;
    @NotNull
    private final JButton scrollUpBtn;
    @NotNull
    private final JButton scrollEndBtn;
    @NotNull
    private final JButton prettyBtn;
    @NotNull
    private final Json prettyJson;
    private static final Logger log = LoggerFactory.getLogger(EditorPanel.class);
    @NotNull
    private static final DynamicIcon saveIcon = new DynamicIcon("icons/save.svg", "icons/save_dark.svg", false, EditorPlugin.class.getClassLoader(), 4, null);

    /*
     * WARNING - void declaration
     */
    public EditorPanel(@NotNull JFrame window, @NotNull File file) {
        void $this$toolbar_u24lambda_u240;
        FlatToolBar $this$findPanel_u24lambda_u240;
        FlatToolBar flatToolBar;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(new BorderLayout());
        this.window = window;
        this.file = file;
        this.text = FilesKt.readText((File)this.file, (Charset)Charsets.UTF_8);
        this.layeredPane = new LayeredPane();
        this.textArea = new RSyntaxTextArea();
        this.scrollPane = new RTextScrollPane((RTextArea)this.textArea);
        FlatToolBar flatToolBar2 = flatToolBar = new FlatToolBar();
        EditorPanel editorPanel = this;
        boolean bl = false;
        $this$findPanel_u24lambda_u240.setFloatable(false);
        editorPanel.findPanel = flatToolBar;
        $this$findPanel_u24lambda_u240 = flatToolBar = new FlatToolBar();
        editorPanel = this;
        boolean bl2 = false;
        $this$toolbar_u24lambda_u240.setFloatable(false);
        editorPanel.toolbar = flatToolBar;
        this.searchTextField = new FlatTextField();
        this.closeFindPanelBtn = new JButton((Icon)Icons.INSTANCE.getClose());
        this.nextBtn = new JButton((Icon)Icons.INSTANCE.getDown());
        this.prevBtn = new JButton((Icon)Icons.INSTANCE.getUp());
        this.context = new SearchContext();
        this.softWrapBtn = new JToggleButton((Icon)Icons.INSTANCE.getSoftWrap());
        this.saveBtn = new JButton((Icon)saveIcon);
        this.scrollUpBtn = new JButton((Icon)Icons.INSTANCE.getScrollUp());
        this.scrollEndBtn = new JButton((Icon)Icons.INSTANCE.getScrollDown());
        this.prettyBtn = new JButton((Icon)Icons.INSTANCE.getReformatCode());
        this.prettyJson = JsonKt.Json$default(null, EditorPanel::prettyJson$lambda$0, (int)1, null);
        this.initView();
        this.initEvents();
    }

    private final EnableManager getEnableManager() {
        return EnableManager.Companion.getInstance();
    }

    /*
     * Unable to fully structure code
     */
    private final void initView() {
        this.textArea.setFont(this.textArea.getFont().deriveFont((float)DatabaseManager.Companion.getInstance().getTerminal().getFontSize()));
        this.textArea.setText(this.text);
        this.textArea.setAntiAliasingEnabled(true);
        this.softWrapBtn.setSelected(this.getEnableManager().getFlag("Plugins.editor.softWrap", false));
        theme = FlatLaf.isLafDark() != false ? Theme.load((InputStream)this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/dark.xml")) : Theme.load((InputStream)this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/idea.xml"));
        theme.apply(this.textArea);
        v0 = FilenameUtils.getExtension((String)this.file.getName());
        if (v0 != null) {
            v1 = v0.toLowerCase(Locale.ROOT);
            v2 = v1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
        } else {
            v2 = null;
        }
        var3_3 = extension = v2;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 96515: {
                if (var3_3.equals("c++")) {
                    tmp = 1;
                }
                break;
            }
            case 98819: {
                if (var3_3.equals("css")) {
                    tmp = 2;
                }
                break;
            }
            case 99610157: {
                if (var3_3.equals("htmlx")) {
                    tmp = 3;
                }
                break;
            }
            case 105543: {
                if (var3_3.equals("jsp")) {
                    tmp = 4;
                }
                break;
            }
            case 98822: {
                if (var3_3.equals("csv")) {
                    tmp = 5;
                }
                break;
            }
            case 3401: {
                if (var3_3.equals("js")) {
                    tmp = 6;
                }
                break;
            }
            case 3593: {
                if (var3_3.equals("py")) {
                    tmp = 7;
                }
                break;
            }
            case 114126: {
                if (var3_3.equals("sql")) {
                    tmp = 8;
                }
                break;
            }
            case 3075967: {
                if (var3_3.equals("dart")) {
                    tmp = 9;
                }
                break;
            }
            case 3254818: {
                if (var3_3.equals("java")) {
                    tmp = 10;
                }
                break;
            }
            case 97301: {
                if (var3_3.equals("bat")) {
                    tmp = 11;
                }
                break;
            }
            case 3669: {
                if (var3_3.equals("sh")) {
                    tmp = 12;
                }
                break;
            }
            case 99796: {
                if (var3_3.equals("dtd")) {
                    tmp = 13;
                }
                break;
            }
            case 118807: {
                if (var3_3.equals("xml")) {
                    tmp = 14;
                }
                break;
            }
            case 3479: {
                if (var3_3.equals("md")) {
                    tmp = 15;
                }
                break;
            }
            case 119768: {
                if (var3_3.equals("yml")) {
                    tmp = 16;
                }
                break;
            }
            case 3271912: {
                if (var3_3.equals("json")) {
                    tmp = 17;
                }
                break;
            }
            case 3213227: {
                if (var3_3.equals("html")) {
                    tmp = 3;
                }
                break;
            }
            case 3701415: {
                if (var3_3.equals("yaml")) {
                    tmp = 16;
                }
                break;
            }
            case 103649: {
                if (var3_3.equals("htm")) {
                    tmp = 3;
                }
                break;
            }
            case 98723: {
                if (var3_3.equals("cpp")) {
                    tmp = 1;
                }
                break;
            }
            case 99: {
                if (var3_3.equals("c")) {
                    tmp = 18;
                }
                break;
            }
            case 114276: {
                if (var3_3.equals("svg")) {
                    tmp = 14;
                }
                break;
            }
            case 104420: {
                if (var3_3.equals("ini")) {
                    tmp = 19;
                }
                break;
            }
            case 99467211: {
                if (var3_3.equals("hosts")) {
                    tmp = 20;
                }
                break;
            }
            case 3304: {
                if (var3_3.equals("go")) {
                    tmp = 21;
                }
                break;
            }
            case 3433: {
                if (var3_3.equals("kt")) {
                    tmp = 22;
                }
                break;
            }
            case 3318169: {
                if (var3_3.equals("less")) {
                    tmp = 23;
                }
                break;
            }
            case 3184: {
                if (var3_3.equals("cs")) {
                    tmp = 24;
                }
                break;
            }
            case 109403696: {
                if (var3_3.equals("shell")) {
                    tmp = 12;
                }
                break;
            }
            case 110968: {
                if (var3_3.equals("php")) {
                    tmp = 25;
                }
                break;
            }
            case 107512: {
                if (var3_3.equals("lua")) {
                    tmp = 26;
                }
                break;
            }
            case -926053069: {
                if (var3_3.equals("properties")) {
                    tmp = 27;
                }
                break;
            }
            case 3711: {
                if (var3_3.equals("ts")) {
                    tmp = 28;
                }
                break;
            }
        }
        switch (tmp) {
            case 10: {
                v3 = "text/java";
                break;
            }
            case 22: {
                v3 = "text/kotlin";
                break;
            }
            case 27: {
                v3 = "text/properties";
                break;
            }
            case 1: {
                v3 = "text/cpp";
                break;
            }
            case 18: {
                v3 = "text/c";
                break;
            }
            case 24: {
                v3 = "text/cs";
                break;
            }
            case 2: {
                v3 = "text/css";
                break;
            }
            case 3: {
                v3 = "text/html";
                break;
            }
            case 6: {
                v3 = "text/javascript";
                break;
            }
            case 28: {
                v3 = "text/typescript";
                break;
            }
            case 14: {
                v3 = "text/xml";
                break;
            }
            case 16: {
                v3 = "text/yaml";
                break;
            }
            case 12: {
                v3 = "text/unix";
                break;
            }
            case 8: {
                v3 = "text/sql";
                break;
            }
            case 11: {
                v3 = "text/bat";
                break;
            }
            case 7: {
                v3 = "text/python";
                break;
            }
            case 25: {
                v3 = "text/php";
                break;
            }
            case 26: {
                v3 = "text/lua";
                break;
            }
            case 23: {
                v3 = "text/less";
                break;
            }
            case 4: {
                v3 = "text/jsp";
                break;
            }
            case 17: {
                v3 = "text/json";
                break;
            }
            case 19: {
                v3 = "text/ini";
                break;
            }
            case 20: {
                v3 = "text/hosts";
                break;
            }
            case 21: {
                v3 = "text/golang";
                break;
            }
            case 13: {
                v3 = "text/dtd";
                break;
            }
            case 9: {
                v3 = "text/dart";
                break;
            }
            case 5: {
                v3 = "text/csv";
                break;
            }
            case 15: {
                v3 = "text/markdown";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v3 = "text/plain";
            }
        }
        this.textArea.setSyntaxEditingStyle(v3);
        this.prettyBtn.setVisible(Intrinsics.areEqual((Object)this.textArea.getSyntaxEditingStyle(), (Object)"text/json") != false || Intrinsics.areEqual((Object)this.textArea.getSyntaxEditingStyle(), (Object)"text/xml") != false);
        this.textArea.discardAllEdits();
        this.scrollPane.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 0, 1, (Color)DynamicColor.Companion.getBorderColor()));
        this.findPanel.setVisible(false);
        this.findPanel.setOpaque(true);
        this.findPanel.setBackground((Color)new DynamicColor("window"));
        this.searchTextField.setBackground(this.findPanel.getBackground());
        this.searchTextField.setPadding(new Insets(0, 4, 0, 0));
        this.searchTextField.setBorder(BorderFactory.createEmptyBorder());
        this.findPanel.add((Component)this.searchTextField);
        this.findPanel.add((Component)this.prevBtn);
        this.findPanel.add((Component)this.nextBtn);
        this.findPanel.add((Component)this.closeFindPanelBtn);
        this.findPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, (Color)DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.toolbar.setOrientation(1);
        this.toolbar.add((Component)this.saveBtn);
        this.toolbar.add((Component)this.scrollUpBtn);
        this.toolbar.add((Component)this.prettyBtn);
        this.toolbar.add((Component)this.softWrapBtn);
        this.toolbar.add((Component)this.scrollEndBtn);
        this.saveBtn.setToolTipText(EditorI18n.INSTANCE.getString("termora.plugins.editor.save"));
        this.scrollUpBtn.setToolTipText(EditorI18n.INSTANCE.getString("termora.plugins.editor.first-line"));
        this.scrollEndBtn.setToolTipText(EditorI18n.INSTANCE.getString("termora.plugins.editor.last-line"));
        this.softWrapBtn.setToolTipText(EditorI18n.INSTANCE.getString("termora.plugins.editor.soft-wrap"));
        this.prettyBtn.setToolTipText(EditorI18n.INSTANCE.getString("termora.plugins.editor.format"));
        viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)this.scrollPane, "Center");
        viewPanel.add((Component)this.toolbar, "East");
        viewPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)DynamicColor.Companion.getBorderColor()));
        v4 = (Component)this.findPanel;
        v5 = JLayeredPane.MODAL_LAYER;
        Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(v4, v5);
        v6 = viewPanel;
        v7 = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(v6, v7);
        this.add((Component)this.layeredPane, "Center");
    }

    private final void initEvents() {
        this.window.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowOpened(WindowEvent e) {
                EditorPanel.access$getScrollPane$p(this.this$0).getVerticalScrollBar().setValue(0);
                EditorPanel.access$getWindow$p(this.this$0).removeWindowListener(this);
            }
        });
        this.softWrapBtn.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$0(this, arg_0));
        this.scrollUpBtn.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$1(this, arg_0));
        this.scrollEndBtn.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$2(this, arg_0));
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(83, this.getToolkit().getMenuShortcutKeyMaskEx()), "Save");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(70, this.getToolkit().getMenuShortcutKeyMaskEx()), "Find");
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(70, this.getToolkit().getMenuShortcutKeyMaskEx() | 0x40), "Format");
        this.searchTextField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "Esc");
        this.searchTextField.getActionMap().put("Esc", new AbstractAction(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
                super("Esc");
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorPanel.access$getTextArea$p(this.this$0).clearMarkAllHighlights();
                EditorPanel.access$getTextArea$p(this.this$0).requestFocusInWindow();
                EditorPanel.access$getFindPanel$p(this.this$0).setVisible(false);
            }
        });
        this.closeFindPanelBtn.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$3(this, arg_0));
        this.textArea.getActionMap().put("Save", new AbstractAction(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
                super("Save");
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                File file = EditorPanel.access$getFile$p(this.this$0);
                String string = EditorPanel.access$getTextArea$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                FilesKt.writeText((File)file, (String)string, (Charset)Charsets.UTF_8);
                String string2 = EditorPanel.access$getTextArea$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                EditorPanel.access$setText$p(this.this$0, string2);
                EditorPanel.access$getWindow$p(this.this$0).setTitle(EditorPanel.access$getFile$p(this.this$0).getName());
            }
        });
        this.saveBtn.addActionListener(this.textArea.getActionMap().get("Save"));
        this.textArea.getActionMap().put("Format", new AbstractAction(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorPanel.access$format(this.this$0);
            }
        });
        this.textArea.getActionMap().put("Find", new AbstractAction(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
                super("Find");
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorPanel.access$getFindPanel$p(this.this$0).setVisible(true);
                EditorPanel.access$getSearchTextField$p(this.this$0).selectAll();
                EditorPanel.access$getSearchTextField$p(this.this$0).requestFocusInWindow();
            }
        });
        this.textArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdaptor(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorPanel.access$getWindow$p(this.this$0).setTitle((String)(EditorPanel.access$getTextArea$p(this.this$0).getText().hashCode() != EditorPanel.access$getText$p(this.this$0).hashCode() ? EditorPanel.access$getFile$p(this.this$0).getName() + " *" : EditorPanel.access$getFile$p(this.this$0).getName()));
            }
        });
        this.searchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdaptor(this){
            final /* synthetic */ EditorPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorPanel.search$default(this.this$0, false, 1, null);
            }
        });
        this.searchTextField.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$4(this, arg_0));
        this.prettyBtn.addActionListener(this.textArea.getActionMap().get("Format"));
        this.prevBtn.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$5(this, arg_0));
        this.nextBtn.addActionListener(arg_0 -> EditorPanel.initEvents$lambda$6(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void format() {
        Object c;
        Object object;
        Object object2;
        int vertical = this.scrollPane.getVerticalScrollBar().getValue();
        int horizontal = this.scrollPane.getHorizontalScrollBar().getValue();
        int caretPosition = this.textArea.getCaretPosition();
        if (Intrinsics.areEqual((Object)this.textArea.getSyntaxEditingStyle(), (Object)"text/json")) {
            object2 = this;
            try {
                void this_$iv;
                $this$format_u24lambda_u240 = object2;
                boolean bl = false;
                Json json = ((EditorPanel)$this$format_u24lambda_u240).prettyJson;
                String string = ((EditorPanel)$this$format_u24lambda_u240).textArea.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                JsonElement json2 = json.parseToJsonElement(string);
                RSyntaxTextArea rSyntaxTextArea = ((EditorPanel)$this$format_u24lambda_u240).textArea;
                Json json3 = ((EditorPanel)$this$format_u24lambda_u240).prettyJson;
                JsonElement value$iv = json2;
                boolean $i$f$encodeToString = false;
                SerializersModule serializersModule = this_$iv.getSerializersModule();
                KType kType = Reflection.typeOf(JsonElement.class);
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                rSyntaxTextArea.setText(this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)value$iv));
                $this$format_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$format_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$format_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = $this$format_u24lambda_u240 = throwable;
                boolean bl = false;
                if (log.isErrorEnabled()) {
                    log.error(((Throwable)it).getMessage(), (Throwable)it);
                }
            }
            object = object2;
        } else {
            Result result;
            if (Intrinsics.areEqual((Object)this.textArea.getSyntaxEditingStyle(), (Object)"text/xml")) {
                Object $this$format_u24lambda_u242;
                $this$format_u24lambda_u240 = this;
                try {
                    $this$format_u24lambda_u242 = (EditorPanel)$this$format_u24lambda_u240;
                    boolean bl = false;
                    Document document = new SAXReader().read((Reader)new StringReader(((EditorPanel)$this$format_u24lambda_u242).textArea.getText()));
                    StringWriter sw = new StringWriter();
                    XMLWriter writer = new XMLWriter((Writer)sw, OutputFormat.createPrettyPrint());
                    writer.write(document);
                    ((EditorPanel)$this$format_u24lambda_u242).textArea.setText(sw.toString());
                    $this$format_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$format_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                $this$format_u24lambda_u240 = $this$format_u24lambda_u242;
                Throwable throwable = Result.exceptionOrNull-impl((Object)$this$format_u24lambda_u240);
                if (throwable != null) {
                    Object it = $this$format_u24lambda_u242 = throwable;
                    boolean bl = false;
                    if (log.isErrorEnabled()) {
                        log.error(((Throwable)it).getMessage(), (Throwable)it);
                    }
                }
                result = Result.box-impl((Object)$this$format_u24lambda_u240);
            } else {
                result = null;
            }
            if (result != null) {
                object = result.unbox-impl();
            } else {
                return;
            }
        }
        object2 = c = object;
        if (Result.isSuccess-impl((Object)object2)) {
            Unit it = (Unit)object2;
            boolean bl = false;
            SwingUtilities.invokeLater(() -> EditorPanel.format$lambda$4$0(this, vertical, horizontal, caretPosition));
        }
    }

    private final void search(boolean searchForward) {
        this.textArea.clearMarkAllHighlights();
        String string = this.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        if (((CharSequence)text).length() == 0) {
            return;
        }
        this.context.setSearchFor(text);
        this.context.setSearchForward(searchForward);
        this.context.setWholeWord(false);
        SearchResult result = SearchEngine.find((JTextArea)((JTextArea)this.textArea), (SearchContext)this.context);
        this.prevBtn.setEnabled(result.getMarkedCount() > 0);
        this.nextBtn.setEnabled(result.getMarkedCount() > 0);
    }

    static /* synthetic */ void search$default(EditorPanel editorPanel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        editorPanel.search(bl);
    }

    public final boolean changes() {
        return !Intrinsics.areEqual((Object)this.text, (Object)this.textArea.getText());
    }

    private static final Unit prettyJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final void initEvents$lambda$0(EditorPanel this$0, ActionEvent it) {
        this$0.getEnableManager().getFlag("Plugins.editor.softWrap", this$0.softWrapBtn.isSelected());
        this$0.textArea.setLineWrap(this$0.softWrapBtn.isSelected());
    }

    private static final void initEvents$lambda$1(EditorPanel this$0, ActionEvent it) {
        this$0.scrollPane.getVerticalScrollBar().setValue(0);
    }

    private static final void initEvents$lambda$2(EditorPanel this$0, ActionEvent it) {
        this$0.scrollPane.getVerticalScrollBar().setValue(this$0.scrollPane.getVerticalScrollBar().getMaximum());
    }

    private static final void initEvents$lambda$3(EditorPanel this$0, ActionEvent it) {
        this$0.searchTextField.getActionMap().get("Esc").actionPerformed(it);
    }

    private static final void initEvents$lambda$4(EditorPanel this$0, ActionEvent it) {
        this$0.nextBtn.doClick(0);
    }

    private static final void initEvents$lambda$5(EditorPanel this$0, ActionEvent it) {
        this$0.search(false);
    }

    private static final void initEvents$lambda$6(EditorPanel this$0, ActionEvent it) {
        this$0.search(true);
    }

    private static final void format$lambda$4$0(EditorPanel this$0, int $vertical, int $horizontal, int $caretPosition) {
        this$0.scrollPane.getVerticalScrollBar().setValue(Math.min($vertical, this$0.scrollPane.getVerticalScrollBar().getMaximum()));
        this$0.scrollPane.getHorizontalScrollBar().setValue(Math.min($horizontal, this$0.scrollPane.getHorizontalScrollBar().getMaximum()));
        if ($caretPosition >= 0 && $caretPosition < this$0.textArea.getDocument().getLength()) {
            this$0.textArea.setCaretPosition($caretPosition);
        }
    }

    public static final /* synthetic */ RTextScrollPane access$getScrollPane$p(EditorPanel $this) {
        return $this.scrollPane;
    }

    public static final /* synthetic */ JFrame access$getWindow$p(EditorPanel $this) {
        return $this.window;
    }

    public static final /* synthetic */ RSyntaxTextArea access$getTextArea$p(EditorPanel $this) {
        return $this.textArea;
    }

    public static final /* synthetic */ File access$getFile$p(EditorPanel $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setText$p(EditorPanel $this, String string) {
        $this.text = string;
    }

    public static final /* synthetic */ void access$format(EditorPanel $this) {
        $this.format();
    }

    public static final /* synthetic */ FlatTextField access$getSearchTextField$p(EditorPanel $this) {
        return $this.searchTextField;
    }

    public static final /* synthetic */ String access$getText$p(EditorPanel $this) {
        return $this.text;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/editor/EditorPanel$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "saveIcon", "Lapp/termora/DynamicIcon;", "editor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lapp/termora/plugins/editor/EditorPanel$LayeredPane;", "Ljavax/swing/JLayeredPane;", "<init>", "(Lapp/termora/plugins/editor/EditorPanel;)V", "doLayout", "", "editor"})
    private final class LayeredPane
    extends JLayeredPane {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            EditorPanel editorPanel = EditorPanel.this;
            Object object3 = object2;
            synchronized (object3) {
                boolean bl = false;
                Component[] componentArray = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component c : componentArray) {
                    if (Intrinsics.areEqual((Object)c, (Object)editorPanel.findPanel)) {
                        int height = Math.max(((EditorPanel)editorPanel).findPanel.getPreferredSize().height, editorPanel.findPanel.getHeight());
                        int x = this.getWidth() / 2;
                        c.setBounds(x, 1, this.getWidth() - x, height);
                        continue;
                    }
                    c.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

