/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding;

import com.glavsoft.rfb.encoding.decoder.CopyRectDecoder;
import com.glavsoft.rfb.encoding.decoder.CursorPosDecoder;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.DesctopSizeDecoder;
import com.glavsoft.rfb.encoding.decoder.FakeDecoder;
import com.glavsoft.rfb.encoding.decoder.HextileDecoder;
import com.glavsoft.rfb.encoding.decoder.RREDecoder;
import com.glavsoft.rfb.encoding.decoder.RawDecoder;
import com.glavsoft.rfb.encoding.decoder.RichCursorDecoder;
import com.glavsoft.rfb.encoding.decoder.TightDecoder;
import com.glavsoft.rfb.encoding.decoder.ZRLEDecoder;
import com.glavsoft.rfb.encoding.decoder.ZlibDecoder;
import java.util.LinkedHashSet;

public enum EncodingType {
    RAW_ENCODING(0, "Raw", RawDecoder.class),
    COPY_RECT(1, "CopyRect", CopyRectDecoder.class),
    RRE(2, "RRE", RREDecoder.class),
    HEXTILE(5, "Hextile", HextileDecoder.class),
    ZLIB(6, "ZLib", ZlibDecoder.class),
    TIGHT(7, "Tight", TightDecoder.class),
    ZRLE(16, "ZRLE", ZRLEDecoder.class),
    RICH_CURSOR(-239, "RichCursor", RichCursorDecoder.class),
    DESKTOP_SIZE(-223, "DesctopSize", DesctopSizeDecoder.class),
    CURSOR_POS(-232, "CursorPos", CursorPosDecoder.class),
    COMPRESS_LEVEL_0(-256, "CompressionLevel0", FakeDecoder.class),
    COMPRESS_LEVEL_1(-255, "CompressionLevel1", null),
    COMPRESS_LEVEL_2(-254, "CompressionLevel2", null),
    COMPRESS_LEVEL_3(-253, "CompressionLevel3", null),
    COMPRESS_LEVEL_4(-252, "CompressionLevel4", null),
    COMPRESS_LEVEL_5(-251, "CompressionLevel5", null),
    COMPRESS_LEVEL_6(-250, "CompressionLevel6", null),
    COMPRESS_LEVEL_7(-249, "CompressionLevel7", null),
    COMPRESS_LEVEL_8(-248, "CompressionLevel8", null),
    COMPRESS_LEVEL_9(-247, "CompressionLevel9", null),
    JPEG_QUALITY_LEVEL_0(-32, "JpegQualityLevel0", FakeDecoder.class),
    JPEG_QUALITY_LEVEL_1(-31, "JpegQualityLevel1", null),
    JPEG_QUALITY_LEVEL_2(-30, "JpegQualityLevel2", null),
    JPEG_QUALITY_LEVEL_3(-29, "JpegQualityLevel3", null),
    JPEG_QUALITY_LEVEL_4(-28, "JpegQualityLevel4", null),
    JPEG_QUALITY_LEVEL_5(-27, "JpegQualityLevel5", null),
    JPEG_QUALITY_LEVEL_6(-26, "JpegQualityLevel6", null),
    JPEG_QUALITY_LEVEL_7(-25, "JpegQualityLevel7", null),
    JPEG_QUALITY_LEVEL_8(-24, "JpegQualityLevel8", null),
    JPEG_QUALITY_LEVEL_9(-23, "JpegQualityLevel9", null);

    private final int id;
    private final String name;
    public final Class<? extends Decoder> klass;
    public static final LinkedHashSet<EncodingType> ordinaryEncodings;
    public static final LinkedHashSet<EncodingType> pseudoEncodings;

    private EncodingType(int id, String name, Class<? extends Decoder> klass) {
        this.id = id;
        this.name = name;
        this.klass = klass;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static EncodingType byId(int id) {
        for (EncodingType type : EncodingType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported encoding code: " + id);
    }

    static {
        ordinaryEncodings = new LinkedHashSet();
        ordinaryEncodings.add(ZRLE);
        ordinaryEncodings.add(TIGHT);
        ordinaryEncodings.add(ZLIB);
        ordinaryEncodings.add(HEXTILE);
        ordinaryEncodings.add(RRE);
        ordinaryEncodings.add(COPY_RECT);
        ordinaryEncodings.add(RAW_ENCODING);
        pseudoEncodings = new LinkedHashSet();
        pseudoEncodings.add(RICH_CURSOR);
        pseudoEncodings.add(CURSOR_POS);
        pseudoEncodings.add(DESKTOP_SIZE);
    }
}

