/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.transport.Transport;

public class ServerInitMessage {
    protected String name;
    protected int framebufferWidth;
    protected int framebufferHeight;
    protected PixelFormat pixelFormat;

    public ServerInitMessage readFrom(Transport transport) throws TransportException {
        this.framebufferWidth = transport.readUInt16();
        this.framebufferHeight = transport.readUInt16();
        this.pixelFormat = new PixelFormat();
        this.pixelFormat.fill(transport);
        this.name = transport.readString();
        return this;
    }

    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ServerInitMessage{name='" + this.name + "', framebufferWidth=" + this.framebufferWidth + ", framebufferHeight=" + this.framebufferHeight + ", pixelFormat=" + String.valueOf(this.pixelFormat) + "}";
    }
}

