/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.settings;

import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.mvp.Model;
import com.glavsoft.viewer.settings.WrongParameterException;

public class ConnectionParams
implements Model {
    public static final int DEFAULT_SSH_PORT = 22;
    private static final int DEFAULT_RFB_PORT = 5900;
    public String hostName;
    private int portNumber;
    public String sshUserName;
    public String sshHostName;
    private int sshPortNumber;
    private boolean useSsh;

    public ConnectionParams(String hostName, int portNumber, boolean useSsh, String sshHostName, int sshPortNumber, String sshUserName) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.sshUserName = sshUserName;
        this.sshHostName = sshHostName;
        this.sshPortNumber = sshPortNumber;
        this.useSsh = useSsh;
    }

    public ConnectionParams(ConnectionParams cp) {
        this.hostName = cp.hostName != null ? cp.hostName : "";
        this.portNumber = cp.portNumber;
        this.sshUserName = cp.sshUserName;
        this.sshHostName = cp.sshHostName;
        this.sshPortNumber = cp.sshPortNumber;
        this.useSsh = cp.useSsh;
    }

    public ConnectionParams() {
        this.hostName = "";
        this.sshUserName = "";
        this.sshHostName = "";
    }

    public ConnectionParams(String hostName, String portNumber) {
        this.hostName = hostName;
        try {
            this.setPortNumber(portNumber);
        }
        catch (WrongParameterException ignore) {
            this.portNumber = 0;
        }
    }

    public boolean isHostNameEmpty() {
        return Strings.isTrimmedEmpty(this.hostName);
    }

    private int parsePortNumber(String port) throws WrongParameterException {
        int portNumber;
        block4: {
            if (null == port) {
                return 0;
            }
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                portNumber = 0;
                if (Strings.isTrimmedEmpty(port)) break block4;
                throw new WrongParameterException("Wrong port number: " + port + "\nMust be in 0..65535");
            }
        }
        if (portNumber > 65535 || portNumber < 0) {
            throw new WrongParameterException("Port number is out of range: " + port + "\nMust be in 0..65535");
        }
        return portNumber;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPortNumber(String port) throws WrongParameterException {
        this.portNumber = this.parsePortNumber(port);
    }

    public void setPortNumber(int port) {
        this.portNumber = port;
    }

    public int getPortNumber() {
        return 0 == this.portNumber ? 5900 : this.portNumber;
    }

    public void setSshPortNumber(String port) throws WrongParameterException {
        try {
            this.sshPortNumber = this.parsePortNumber(port);
        }
        catch (WrongParameterException e) {
            throw new WrongParameterException("SSH port number error. " + e.getMessage());
        }
    }

    public void setSshPortNumber(int port) {
        this.sshPortNumber = port;
    }

    public int getSshPortNumber() {
        return 0 == this.sshPortNumber ? 22 : this.sshPortNumber;
    }

    public void setUseSsh(boolean useSsh) {
        this.useSsh = useSsh;
    }

    public boolean useSsh() {
        return this.useSsh && !Strings.isTrimmedEmpty(this.sshHostName);
    }

    public boolean getUseSsh() {
        return this.useSsh();
    }

    public String getSshUserName() {
        return this.sshUserName;
    }

    public void setSshUserName(String sshUserName) {
        this.sshUserName = sshUserName;
    }

    public String getSshHostName() {
        return this.sshHostName;
    }

    public void setSshHostName(String sshHostName) {
        this.sshHostName = sshHostName;
    }

    public void completeEmptyFieldsFrom(ConnectionParams other) {
        if (null == other) {
            return;
        }
        if (Strings.isTrimmedEmpty(this.hostName) && !Strings.isTrimmedEmpty(other.hostName)) {
            this.hostName = other.hostName;
        }
        if (0 == this.portNumber && other.portNumber != 0) {
            this.portNumber = other.portNumber;
        }
        if (Strings.isTrimmedEmpty(this.sshUserName) && !Strings.isTrimmedEmpty(other.sshUserName)) {
            this.sshUserName = other.sshUserName;
        }
        if (Strings.isTrimmedEmpty(this.sshHostName) && !Strings.isTrimmedEmpty(other.sshHostName)) {
            this.sshHostName = other.sshHostName;
        }
        if (0 == this.sshPortNumber && other.sshPortNumber != 0) {
            this.sshPortNumber = other.sshPortNumber;
        }
        this.useSsh |= other.useSsh;
    }

    public String toString() {
        return this.hostName != null ? this.hostName : "";
    }

    public String toPrint() {
        return "ConnectionParams{hostName='" + this.hostName + "', portNumber=" + this.portNumber + ", sshUserName='" + this.sshUserName + "', sshHostName='" + this.sshHostName + "', sshPortNumber=" + this.sshPortNumber + ", useSsh=" + this.useSsh + "}";
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof ConnectionParams)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConnectionParams o = (ConnectionParams)obj;
        return this.isEqualsNullable(this.hostName, o.hostName) && this.getPortNumber() == o.getPortNumber() && this.useSsh == o.useSsh && this.isEqualsNullable(this.sshHostName, o.sshHostName) && this.getSshPortNumber() == o.getSshPortNumber() && this.isEqualsNullable(this.sshUserName, o.sshUserName);
    }

    private boolean isEqualsNullable(String one, String another) {
        return (null == one ? "" : one).equals(null == another ? "" : another);
    }

    public int hashCode() {
        long hash = (this.hostName != null ? this.hostName.hashCode() : 0) + this.portNumber * 17 + (this.useSsh ? 781 : 693) + (this.sshHostName != null ? this.sshHostName.hashCode() : 0) * 23 + (this.sshUserName != null ? this.sshUserName.hashCode() : 0) * 37 + this.sshPortNumber * 41;
        return (int)hash;
    }

    public void clearFields() {
        this.hostName = "";
        this.portNumber = 0;
        this.useSsh = false;
        this.sshHostName = null;
        this.sshUserName = null;
        this.sshPortNumber = 0;
    }
}

