/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.settings;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.viewer.settings.LocalMouseCursorShape;
import com.glavsoft.viewer.settings.UiSettingsData;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UiSettings {
    public static final int MIN_SCALE_PERCENT = 10;
    public static final int MAX_SCALE_PERCENT = 500;
    private static final int SCALE_PERCENT_ZOOMING_STEP = 10;
    public static final int CHANGED_SCALE_FACTOR = 1;
    public static final int CHANGED_MOUSE_CURSOR_SHAPE = 2;
    public static final int CHANGED_FULL_SCREEN = 4;
    private final List<IChangeSettingsListener> listeners = new CopyOnWriteArrayList<IChangeSettingsListener>();
    private int changedSettingsMask = 0;
    private final UiSettingsData uiSettingsData;
    public boolean showControls = true;
    public boolean showConnectionDialog = false;

    public UiSettings() {
        this.uiSettingsData = new UiSettingsData();
        this.changedSettingsMask = 0;
    }

    public UiSettings(UiSettings uiSettings) {
        this.uiSettingsData = new UiSettingsData(uiSettings.getScalePercent(), uiSettings.getMouseCursorShape(), uiSettings.isFullScreen());
        this.changedSettingsMask = uiSettings.changedSettingsMask;
    }

    public double getScaleFactor() {
        return this.uiSettingsData.getScalePercent() / 100.0;
    }

    public void setScalePercent(double scalePercent) {
        if (this.uiSettingsData.setScalePercent(scalePercent)) {
            this.changedSettingsMask |= 1;
        }
    }

    public void addListener(IChangeSettingsListener listener) {
        this.listeners.add(listener);
    }

    void fireListeners() {
        if (null == this.listeners) {
            return;
        }
        SettingsChangedEvent event = new SettingsChangedEvent(new UiSettings(this));
        this.changedSettingsMask = 0;
        for (IChangeSettingsListener listener : this.listeners) {
            listener.settingsChanged(event);
        }
    }

    public void zoomOut() {
        double oldScaleFactor = this.uiSettingsData.getScalePercent();
        double scaleFactor = (int)(this.uiSettingsData.getScalePercent() / 10.0) * 10;
        if (scaleFactor == oldScaleFactor) {
            scaleFactor -= 10.0;
        }
        if (scaleFactor < 10.0) {
            scaleFactor = 10.0;
        }
        this.setScalePercent(scaleFactor);
        this.fireListeners();
    }

    public void zoomIn() {
        double scaleFactor = (int)(this.uiSettingsData.getScalePercent() / 10.0) * 10 + 10;
        if (scaleFactor > 500.0) {
            scaleFactor = 500.0;
        }
        this.setScalePercent(scaleFactor);
        this.fireListeners();
    }

    public void zoomAsIs() {
        this.setScalePercent(100.0);
        this.fireListeners();
    }

    public void zoomToFit(int containerWidth, int containerHeight, int fbWidth, int fbHeight) {
        int scalePromille = Math.min(1000 * containerWidth / fbWidth, 1000 * containerHeight / fbHeight);
        while ((double)(fbWidth * scalePromille) / 1000.0 > (double)containerWidth || (double)(fbHeight * scalePromille) / 1000.0 > (double)containerHeight) {
            --scalePromille;
        }
        this.setScalePercent((double)scalePromille / 10.0);
        this.fireListeners();
    }

    public boolean isChangedMouseCursorShape() {
        return (this.changedSettingsMask & 2) == 2;
    }

    public static boolean isUiSettingsChangedFired(SettingsChangedEvent event) {
        return event.getSource() instanceof UiSettings;
    }

    public double getScalePercent() {
        return this.uiSettingsData.getScalePercent();
    }

    public String getScalePercentFormatted() {
        DecimalFormat numberFormat = new DecimalFormat("###.#");
        return numberFormat.format(this.uiSettingsData.getScalePercent());
    }

    public LocalMouseCursorShape getMouseCursorShape() {
        return this.uiSettingsData.getMouseCursorShape();
    }

    public void setMouseCursorShape(LocalMouseCursorShape mouseCursorShape) {
        if (this.uiSettingsData.setMouseCursorShape(mouseCursorShape)) {
            this.changedSettingsMask |= 2;
            this.fireListeners();
        }
    }

    public void copyDataFrom(UiSettingsData other) {
        this.copyDataFrom(other, 0);
    }

    public void copyDataFrom(UiSettingsData other, int mask) {
        if (null == other) {
            return;
        }
        if ((mask & 1) == 0) {
            this.uiSettingsData.setScalePercent(other.getScalePercent());
        }
        if ((mask & 2) == 0) {
            this.uiSettingsData.setMouseCursorShape(other.getMouseCursorShape());
        }
        if ((mask & 4) == 0) {
            this.uiSettingsData.setFullScreen(other.isFullScreen());
        }
    }

    public void setFullScreen(boolean isFullScreen) {
        if (this.uiSettingsData.setFullScreen(isFullScreen)) {
            this.changedSettingsMask |= 4;
            this.fireListeners();
        }
    }

    public boolean isFullScreen() {
        return this.uiSettingsData.isFullScreen();
    }

    public UiSettingsData getData() {
        return this.uiSettingsData;
    }

    public String toString() {
        return "UiSettings{scalePercent=" + this.uiSettingsData.getScalePercent() + ", fullScreen=" + this.uiSettingsData.isFullScreen() + ", mouseCursorShape=" + String.valueOf((Object)this.uiSettingsData.getMouseCursorShape()) + "}";
    }
}

