/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.viewer.mvp.Presenter;
import com.glavsoft.viewer.settings.ConnectionParams;
import com.glavsoft.viewer.swing.CancelConnectionException;
import com.glavsoft.viewer.swing.CancelConnectionQuietlyException;
import com.glavsoft.viewer.swing.ConnectionErrorException;
import com.glavsoft.viewer.swing.ConnectionPresenter;
import com.glavsoft.viewer.swing.ssh.SshConnectionManager;
import com.glavsoft.viewer.workers.NetworkConnectionWorker;
import java.awt.Component;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class SwingNetworkConnectionWorker
extends SwingWorker<Socket, String>
implements NetworkConnectionWorker {
    public static final int MAX_HOSTNAME_LENGTH_FOR_MESSAGES = 40;
    private final Component parent;
    private Logger logger;
    private boolean hasSshSupport;
    private ConnectionParams connectionParams;
    private ConnectionPresenter presenter;
    private SshConnectionManager sshConnectionManager;

    public SwingNetworkConnectionWorker(Component parent) {
        this.parent = parent;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Socket doInBackground() throws Exception {
        String host;
        int port;
        String s = "<b>" + this.connectionParams.hostName + "</b>:" + this.connectionParams.getPortNumber();
        if (this.connectionParams.useSsh()) {
            s = s + " <i>(via com.glavsoft.viewer.swing.ssh://" + this.connectionParams.sshUserName + "@" + this.connectionParams.sshHostName + ":" + this.connectionParams.getSshPortNumber() + ")</i>";
        }
        String message = "<html>Trying to connect to " + s + "</html>";
        this.logger.info(message.replaceAll("<[^<>]+?>", ""));
        this.publish(message);
        if (this.hasSshSupport && this.connectionParams.useSsh()) {
            try {
                this.sshConnectionManager = SshConnectionManager.createManager(this.parent);
            }
            catch (ConnectionErrorException e) {
                this.hasSshSupport = false;
                throw e;
            }
            message = "Creating SSH tunnel to " + this.connectionParams.sshHostName + ":" + this.connectionParams.getSshPortNumber();
            this.logger.info(message);
            this.publish(message);
            port = this.sshConnectionManager.connect(this.connectionParams);
            if (!this.sshConnectionManager.isConnected()) throw new ConnectionErrorException("Could not create SSH tunnel: " + this.sshConnectionManager.getErrorMessage());
            host = "127.0.0.1";
            message = "SSH tunnel established: " + host + ":" + port;
            this.logger.info(message);
            this.publish(message);
        } else {
            host = this.connectionParams.hostName;
            port = this.connectionParams.getPortNumber();
        }
        message = "Connecting to host " + host + ":" + port + (this.connectionParams.useSsh() ? " (tunneled)" : "");
        this.logger.info(message);
        this.publish(message);
        return new Socket(host, port);
    }

    private String formatHostString(String hostName) {
        if (hostName.length() <= 40) {
            return hostName;
        }
        return hostName.substring(0, 40) + "...";
    }

    @Override
    protected void process(List<String> strings) {
        String message = strings.get(strings.size() - 1);
        this.presenter.showMessage(message);
    }

    @Override
    protected void done() {
        try {
            Socket socket = (Socket)this.get();
            this.presenter.successfulNetworkConnection(socket);
        }
        catch (CancellationException e) {
            this.logger.info("Cancelled: " + e.getMessage());
            e.printStackTrace();
            this.presenter.showMessage("Cancelled");
            this.presenter.connectionFailed();
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted");
            this.presenter.showMessage("Interrupted");
            this.presenter.connectionFailed();
        }
        catch (ExecutionException e) {
            Object errorMessage = null;
            try {
                throw e.getCause();
            }
            catch (UnknownHostException uhe) {
                this.logger.severe("Unknown host: " + this.connectionParams.hostName);
                errorMessage = "Unknown host: '" + this.formatHostString(this.connectionParams.hostName) + "'";
            }
            catch (IOException ioe) {
                this.logger.severe("Couldn't connect to '" + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + "':\n" + ioe.getMessage());
                this.logger.log(Level.FINEST, "Couldn't connect to '" + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + "':\n" + ioe.getMessage(), ioe);
                errorMessage = "Couldn't connect to '" + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber() + "':\n" + ioe.getMessage();
            }
            catch (CancelConnectionQuietlyException cce) {
                this.logger.warning("Cancelled by user: " + cce.getMessage());
            }
            catch (CancelConnectionException cce) {
                this.logger.severe("Cancelled: " + cce.getMessage());
                errorMessage = cce.getMessage();
            }
            catch (SecurityException ace) {
                this.logger.severe("Couldn't connect to: " + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + ": " + ace.getMessage());
                this.logger.log(Level.FINEST, "Couldn't connect to: " + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + ": " + ace.getMessage(), ace);
                errorMessage = "Access control error";
            }
            catch (ConnectionErrorException cee) {
                this.logger.severe(cee.getMessage() + " host: " + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber());
                errorMessage = cee.getMessage() + "\nHost: " + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber();
            }
            catch (Throwable throwable) {
                this.logger.log(Level.FINEST, "Couldn't connect to '" + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber() + "':\n" + throwable.getMessage(), throwable);
                errorMessage = "Couldn't connect to '" + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber() + "':\n" + throwable.getMessage();
            }
            if (errorMessage != null) {
                this.presenter.showConnectionErrorDialog((String)errorMessage);
            }
            this.presenter.clearMessage();
            this.presenter.connectionFailed();
        }
    }

    @Override
    public void setConnectionParams(ConnectionParams connectionParams) {
        this.connectionParams = connectionParams;
    }

    @Override
    public void setPresenter(Presenter presenter) {
        this.presenter = (ConnectionPresenter)presenter;
    }

    @Override
    public void setHasSshSupport(boolean hasSshSupport) {
        this.hasSshSupport = hasSshSupport;
    }

    @Override
    public boolean cancel() {
        if (this.hasSshSupport && this.sshConnectionManager != null && this.sshConnectionManager.isConnected()) {
            this.sshConnectionManager.closeConnection();
            this.sshConnectionManager = null;
        }
        return super.cancel(true);
    }
}

