/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.sync;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.ResponseException;
import app.termora.plugins.sync.GistFile;
import app.termora.plugins.sync.GistResponse;
import app.termora.plugins.sync.GitSyncer;
import app.termora.plugins.sync.SyncConfig;
import app.termora.plugins.sync.SyncRange;
import java.io.Closeable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u001e\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lapp/termora/plugins/sync/GitLabSyncer;", "Lapp/termora/plugins/sync/GitSyncer;", "<init>", "()V", "domain", "", "Lapp/termora/plugins/sync/SyncConfig;", "getDomain", "(Lapp/termora/plugins/sync/SyncConfig;)Ljava/lang/String;", "getRawSnippet", "config", "filename", "newPullRequestBuilder", "Lokhttp3/Request$Builder;", "newPushRequestBuilder", "gistFiles", "", "Lapp/termora/plugins/sync/GistFile;", "parsePullResponse", "Lapp/termora/plugins/sync/GistResponse;", "response", "Lokhttp3/Response;", "parsePullResponseFileNames", "Companion", "sync"})
@SourceDebugExtension(value={"SMAP\nGitLabSyncer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabSyncer.kt\napp/termora/plugins/sync/GitLabSyncer\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n29#2,3:120\n29#2,3:132\n205#3:123\n1563#4:124\n1634#4,3:125\n1563#4:128\n1634#4,3:129\n*S KotlinDebug\n*F\n+ 1 GitLabSyncer.kt\napp/termora/plugins/sync/GitLabSyncer\n*L\n57#1:120,3\n66#1:132,3\n57#1:123\n93#1:124\n93#1:125,3\n116#1:128\n116#1:129,3\n*E\n"})
public final class GitLabSyncer
extends GitSyncer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private GitLabSyncer() {
    }

    private final String getDomain(SyncConfig $this$domain) {
        return (String)MapsKt.getValue($this$domain.getOptions(), (Object)"domain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getRawSnippet(SyncConfig config, String filename) {
        String name = URLEncoder.encode(filename, StandardCharsets.UTF_8);
        Request request = new Request.Builder().get().url(this.getDomain(config) + "/v4/snippets/" + config.getGistId() + "/files/main/" + name + "/raw").header("PRIVATE-TOKEN", config.getToken()).build();
        Closeable closeable = (Closeable)this.getHttpClient().newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                IOUtils.closeQuietly((Closeable)((Closeable)response));
                throw new ResponseException(response.code(), response);
            }
            String string = this.parseResponse(response);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Request.Builder newPullRequestBuilder(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new Request.Builder().get().url(this.getDomain(config) + "/v4/snippets/" + config.getGistId()).header("PRIVATE-TOKEN", config.getToken());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Request.Builder newPushRequestBuilder(@NotNull List<GistFile> gistFiles, @NotNull SyncConfig config) {
        void value$iv;
        void this_$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter(gistFiles, (String)"gistFiles");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean create = StringsKt.isBlank((CharSequence)config.getGistId());
        Set oldFileNames = new LinkedHashSet();
        if (!create) {
            Response response = this.getHttpClient().newCall(this.newPullRequestBuilder(config).build()).execute();
            oldFileNames.addAll((Collection)this.parsePullResponseFileNames(response, config));
        }
        Json json = Application.INSTANCE.getOhMyJson();
        boolean $i$f$buildJsonObject22 = false;
        JsonObjectBuilder $this$newPushRequestBuilder_u24lambda_u243 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        if (create) {
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243, (String)"visibility", (String)"private");
            v0 = JsonElementBuildersKt.put((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243, (String)"title", (String)this.getDescription());
        } else {
            v0 = JsonElementBuildersKt.put((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243, (String)"id", (Number)Integer.parseInt(config.getGistId()));
        }
        JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243, (String)"files", arg_0 -> GitLabSyncer.newPushRequestBuilder$lambda$3$lambda$2(gistFiles, create, oldFileNames, arg_0));
        JsonObject $i$f$buildJsonObject22 = builder$iv.build();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        String content = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)value$iv);
        RequestBody requestBody = RequestBody.Companion.create(content, MediaType.Companion.parse("application/json; charset=utf-8"));
        Request.Builder builder = new Request.Builder();
        Request.Builder builder2 = create ? builder.post(requestBody).url(this.getDomain(config) + "/v4/snippets") : builder.put(requestBody).url(this.getDomain(config) + "/v4/snippets/" + config.getGistId());
        return builder.header("PRIVATE-TOKEN", config.getToken());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GistResponse parsePullResponse(@NotNull Response response, @NotNull SyncConfig config) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List gists = new ArrayList();
        Iterable $this$map$iv = config.getRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SyncRange syncRange = (SyncRange)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        List rangeNames = (List)destination$iv$iv;
        for (String e : this.parsePullResponseFileNames(response, config)) {
            if (!rangeNames.contains(e)) continue;
            gists.add(new GistFile(e, this.getRawSnippet(config, e)));
        }
        return GistResponse.copy$default(super.parsePullResponse(response, config), null, gists, 1, null);
    }

    private final List<String> parsePullResponseFileNames(Response response, SyncConfig config) {
        JsonObject it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (!response.isSuccessful()) {
            throw new ResponseException(response.code(), response);
        }
        String text = this.parseResponse(response);
        JsonObject json = JsonElementKt.getJsonObject((JsonElement)Application.INSTANCE.getOhMyJson().parseToJsonElement(text));
        JsonArray files = JsonElementKt.getJsonArray((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"files")));
        if (files.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = (Iterable)files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonElementKt.getJsonObject((JsonElement)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JsonObject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)it), (Object)"path"))).getContent());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit newPushRequestBuilder$lambda$3$lambda$2(List $gistFiles, boolean $create, Set $oldFileNames, JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        for (GistFile file : $gistFiles) {
            void $this$newPushRequestBuilder_u24lambda_u243_u24lambda_u242_u24lambda_u241;
            JsonObjectBuilder builder$iv;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
            JsonArrayBuilder jsonArrayBuilder = $this$putJsonArray;
            boolean bl = false;
            if (!$create) {
                JsonElementBuildersKt.put((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243_u24lambda_u242_u24lambda_u241, (String)"action", (String)($oldFileNames.contains(file.getFilename()) ? "update" : "create"));
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243_u24lambda_u242_u24lambda_u241, (String)"content", (String)file.getContent());
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$newPushRequestBuilder_u24lambda_u243_u24lambda_u242_u24lambda_u241, (String)"file_path", (String)file.getFilename());
            jsonArrayBuilder.add((JsonElement)builder$iv.build());
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ GitLabSyncer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/plugins/sync/GitLabSyncer$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/plugins/sync/GitLabSyncer;", "sync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitLabSyncer getInstance() {
            return (GitLabSyncer)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(GitLabSyncer.class), Companion::getInstance$lambda$0);
        }

        private static final GitLabSyncer getInstance$lambda$0() {
            return new GitLabSyncer(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

