/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.sync;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.account.AccountManager;
import app.termora.plugins.sync.GistResponse;
import app.termora.plugins.sync.GitHubSyncer;
import app.termora.plugins.sync.GitLabSyncer;
import app.termora.plugins.sync.GiteeSyncer;
import app.termora.plugins.sync.SyncConfig;
import app.termora.plugins.sync.SyncI18n;
import app.termora.plugins.sync.SyncProperties;
import app.termora.plugins.sync.SyncRange;
import app.termora.plugins.sync.SyncType;
import app.termora.plugins.sync.Syncer;
import app.termora.plugins.sync.WebDAVSyncer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0004\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0004"}, d2={"Lapp/termora/plugins/sync/SyncManager;", "Lapp/termora/Disposable;", "<init>", "()V", "sync", "Lapp/termora/plugins/sync/SyncProperties;", "getSync", "()Lapp/termora/plugins/sync/SyncProperties;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "job", "Lkotlinx/coroutines/Job;", "disableTrigger", "", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "trigger", "", "triggerOnChanged", "config", "Lapp/termora/plugins/sync/SyncConfig;", "Lapp/termora/plugins/sync/SyncManager$SyncResponse;", "getSyncConfig", "syncImmediately", "pull", "Lapp/termora/plugins/sync/GistResponse;", "push", "dispose", "Companion", "SyncerProvider", "SyncResponse"})
public final class SyncManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
    @Nullable
    private Job job;
    private boolean disableTrigger;
    private static final Logger log = LoggerFactory.getLogger(SyncManager.class);

    private SyncManager() {
    }

    private final SyncProperties getSync() {
        return SyncProperties.Companion.getInstance();
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    private final void trigger() {
        this.trigger(this.getSyncConfig());
    }

    public final void triggerOnChanged() {
        if (Intrinsics.areEqual((Object)this.getSync().getPolicy(), (Object)"OnChange")) {
            this.trigger();
        }
    }

    private final void trigger(SyncConfig config) {
        if (this.disableTrigger) {
            return;
        }
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (!this.getAccountManager().isLocally()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Automatic synchronisation is interrupted");
        }
        this.job = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, config, null){
            int I$0;
            int label;
            final /* synthetic */ SyncManager this$0;
            final /* synthetic */ SyncConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        seconds = Random.Default.nextInt(10, 30);
                        if (SyncManager.access$getLog$cp().isInfoEnabled()) {
                            SyncManager.access$getLog$cp().info("Trigger synchronisation, which will take place after {} seconds", (Object)Boxing.boxInt((int)seconds));
                        }
                        this.I$0 = seconds;
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)seconds, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        seconds = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (SyncManager.access$getDisableTrigger$p(this.this$0)) ** GOTO lbl34
                        try {
                            if (SyncManager.access$getLog$cp().isInfoEnabled()) {
                                SyncManager.access$getLog$cp().info("Automatic synchronisation begin");
                            }
                            SyncManager.access$setJob$p(this.this$0, null);
                            this.this$0.sync(this.$config);
                            SyncManager.access$getSync(this.this$0).setLastSyncTime(System.currentTimeMillis());
                            if (SyncManager.access$getLog$cp().isInfoEnabled()) {
                                SyncManager.access$getLog$cp().info("Automatic synchronisation end");
                            }
                        }
                        catch (Exception e) {
                            if (!SyncManager.access$getLog$cp().isErrorEnabled()) ** GOTO lbl34
                            SyncManager.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                        }
lbl34:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final SyncResponse sync(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.syncImmediately(config);
    }

    private final SyncConfig getSyncConfig() {
        Set range = new LinkedHashSet();
        if (this.getSync().getRangeHosts()) {
            range.add(SyncRange.Hosts);
        }
        if (this.getSync().getRangeKeyPairs()) {
            range.add(SyncRange.KeyPairs);
        }
        if (this.getSync().getRangeKeywordHighlights()) {
            range.add(SyncRange.KeywordHighlights);
        }
        if (this.getSync().getRangeMacros()) {
            range.add(SyncRange.Macros);
        }
        if (this.getSync().getRangeKeymap()) {
            range.add(SyncRange.Keymap);
        }
        if (this.getSync().getRangeSnippets()) {
            range.add(SyncRange.Snippets);
        }
        return new SyncConfig(this.getSync().getType(), this.getSync().getToken(), this.getSync().getGist(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"domain", (Object)this.getSync().getDomain())), range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SyncResponse syncImmediately(SyncConfig config) {
        SyncManager syncManager = this;
        synchronized (syncManager) {
            boolean bl = false;
            SyncResponse syncResponse = new SyncResponse(this.pull(config), this.push(config));
            return syncResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GistResponse pull(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.getAccountManager().isLocally()) {
            throw new IllegalStateException(SyncI18n.INSTANCE.getString("termora.plugins.sync.disabled-sync"));
        }
        SyncManager syncManager = this;
        synchronized (syncManager) {
            GistResponse gistResponse;
            boolean bl = false;
            this.disableTrigger = true;
            try {
                GistResponse gistResponse2 = SyncerProvider.Companion.getInstance().getSyncer(config.getType()).pull(config);
                this.disableTrigger = false;
                gistResponse = gistResponse2;
            }
            catch (Throwable throwable) {
                this.disableTrigger = false;
                throw throwable;
            }
            return gistResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GistResponse push(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.getAccountManager().isLocally()) {
            throw new IllegalStateException(SyncI18n.INSTANCE.getString("termora.plugins.sync.disabled-sync"));
        }
        SyncManager syncManager = this;
        synchronized (syncManager) {
            GistResponse gistResponse;
            boolean bl = false;
            try {
                this.disableTrigger = true;
                GistResponse gistResponse2 = SyncerProvider.Companion.getInstance().getSyncer(config.getType()).push(config);
                this.disableTrigger = false;
                gistResponse = gistResponse2;
            }
            catch (Throwable throwable) {
                this.disableTrigger = false;
                throw throwable;
            }
            return gistResponse;
        }
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    public /* synthetic */ SyncManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ boolean access$getDisableTrigger$p(SyncManager $this) {
        return $this.disableTrigger;
    }

    public static final /* synthetic */ void access$setJob$p(SyncManager $this, Job job) {
        $this.job = job;
    }

    public static final /* synthetic */ SyncProperties access$getSync(SyncManager $this) {
        return $this.getSync();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/sync/SyncManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/plugins/sync/SyncManager;", "sync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SyncManager getInstance() {
            return (SyncManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(SyncManager.class), Companion::getInstance$lambda$0);
        }

        private static final SyncManager getInstance$lambda$0() {
            return new SyncManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lapp/termora/plugins/sync/SyncManager$SyncResponse;", "", "pull", "Lapp/termora/plugins/sync/GistResponse;", "push", "<init>", "(Lapp/termora/plugins/sync/GistResponse;Lapp/termora/plugins/sync/GistResponse;)V", "getPull", "()Lapp/termora/plugins/sync/GistResponse;", "getPush", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sync"})
    public static final class SyncResponse {
        @NotNull
        private final GistResponse pull;
        @NotNull
        private final GistResponse push;

        public SyncResponse(@NotNull GistResponse pull, @NotNull GistResponse push) {
            Intrinsics.checkNotNullParameter((Object)pull, (String)"pull");
            Intrinsics.checkNotNullParameter((Object)push, (String)"push");
            this.pull = pull;
            this.push = push;
        }

        @NotNull
        public final GistResponse getPull() {
            return this.pull;
        }

        @NotNull
        public final GistResponse getPush() {
            return this.push;
        }

        @NotNull
        public final GistResponse component1() {
            return this.pull;
        }

        @NotNull
        public final GistResponse component2() {
            return this.push;
        }

        @NotNull
        public final SyncResponse copy(@NotNull GistResponse pull, @NotNull GistResponse push) {
            Intrinsics.checkNotNullParameter((Object)pull, (String)"pull");
            Intrinsics.checkNotNullParameter((Object)push, (String)"push");
            return new SyncResponse(pull, push);
        }

        public static /* synthetic */ SyncResponse copy$default(SyncResponse syncResponse, GistResponse gistResponse, GistResponse gistResponse2, int n, Object object) {
            if ((n & 1) != 0) {
                gistResponse = syncResponse.pull;
            }
            if ((n & 2) != 0) {
                gistResponse2 = syncResponse.push;
            }
            return syncResponse.copy(gistResponse, gistResponse2);
        }

        @NotNull
        public String toString() {
            return "SyncResponse(pull=" + this.pull + ", push=" + this.push + ")";
        }

        public int hashCode() {
            int result = this.pull.hashCode();
            result = result * 31 + this.push.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SyncResponse)) {
                return false;
            }
            SyncResponse syncResponse = (SyncResponse)other;
            if (!Intrinsics.areEqual((Object)this.pull, (Object)syncResponse.pull)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.push, (Object)syncResponse.push);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/sync/SyncManager$SyncerProvider;", "", "<init>", "()V", "getSyncer", "Lapp/termora/plugins/sync/Syncer;", "type", "Lapp/termora/plugins/sync/SyncType;", "Companion", "sync"})
    private static final class SyncerProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private SyncerProvider() {
        }

        @NotNull
        public final Syncer getSyncer(@NotNull SyncType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> GitHubSyncer.Companion.getInstance();
                case 2 -> GiteeSyncer.Companion.getInstance();
                case 3 -> GitLabSyncer.Companion.getInstance();
                case 4 -> WebDAVSyncer.Companion.getInstance();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ SyncerProvider(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/plugins/sync/SyncManager$SyncerProvider$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/plugins/sync/SyncManager$SyncerProvider;", "sync"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SyncerProvider getInstance() {
                return (SyncerProvider)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(SyncerProvider.class), Companion::getInstance$lambda$0);
            }

            private static final SyncerProvider getInstance$lambda$0() {
                return new SyncerProvider(null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SyncType.values().length];
                try {
                    nArray[SyncType.GitHub.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SyncType.Gitee.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SyncType.GitLab.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SyncType.WebDAV.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

