/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.ListBucketsRequest;
import com.qcloud.cos.model.ListBucketsResult;
import com.qcloud.cos.region.Region;
import java.util.ArrayList;
import java.util.List;

public class BucketDemo {
    private static String secretId = System.getenv("SECRETID");
    private static String secretKey = System.getenv("SECRETKEY");
    private static String bucketName = System.getenv("BUCKET_NAME");
    private static String cosRegion = System.getenv("REGION");
    private static COSClient cosClient = BucketDemo.createCli();

    public static void main(String[] args) {
        try {
            BucketDemo.createBucketDemo();
            BucketDemo.judgeBucketExistDemo();
            BucketDemo.listBuckets();
            BucketDemo.deleteBucketDemo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cosClient.shutdown();
        }
    }

    private static COSClient createCli() {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(cosRegion));
        COSClient cosclient = new COSClient(cred, clientConfig);
        return cosclient;
    }

    private static void createBucketDemo() {
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
        createBucketRequest.setCannedAcl(CannedAccessControlList.PublicRead);
        Bucket bucket = cosClient.createBucket(createBucketRequest);
        System.out.println("create bucket, bucketName is " + bucket.getName());
    }

    private static void deleteBucketDemo() {
        cosClient.deleteBucket(bucketName);
        System.out.println("delete bucket, bucketName is " + bucketName);
    }

    private static void judgeBucketExistDemo() {
        boolean isExist = cosClient.doesBucketExist(bucketName);
        if (isExist) {
            System.out.println(bucketName + " is exist");
        } else {
            System.out.println(bucketName + " is not exist");
        }
    }

    private static void listBuckets() {
        List<Bucket> buckets = cosClient.listBuckets();
        for (Bucket bucket : buckets) {
            System.out.println(bucket.getName());
            System.out.println(bucket.getLocation());
            System.out.println(bucket.getOwner());
            System.out.println(bucket.getType());
            System.out.println(bucket.getBucketType());
        }
    }

    private static void listAllBucket() {
        ListBucketsRequest listBucketsRequest = new ListBucketsRequest();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        while (true) {
            ListBucketsResult result = cosClient.getService(listBucketsRequest);
            buckets.addAll(result.getBuckets());
            if (!result.isTruncated()) break;
            listBucketsRequest.setMarker(result.getNextMarker());
        }
        for (Bucket bucket : buckets) {
            System.out.println(bucket.getName());
            System.out.println(bucket.getLocation());
        }
        System.out.println("finish list all buckets, totally " + buckets.size() + " buckets.");
    }

    private static void createMAZBucketDemo() {
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
        try {
            Bucket bucket = cosClient.createMAZBucket(createBucketRequest);
            System.out.println("create MAZ bucket, bucketName is " + bucket.getName());
        }
        catch (CosServiceException cse) {
            cse.printStackTrace();
        }
        catch (CosClientException cce) {
            cce.printStackTrace();
        }
    }
}

