/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.AigcMetadata;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class TranscodeTemplateDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        TranscodeTemplateDemo.describeMediaTemplates(client);
    }

    public static void createMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTag("Transcode");
        request.setName("mark-test-2");
        request.getContainer().setFormat("mp4");
        MediaVideoObject video = request.getVideo();
        video.setCodec("H.264");
        video.setProfile("high");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        video.setPreset("medium");
        video.setBufSize("1000");
        video.setMaxrate("10");
        MediaAudioObject audio = request.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("1");
        MediaTransConfigObject transConfig = request.getTransConfig();
        transConfig.setAdjDarMethod("scale");
        transConfig.setIsCheckReso("false");
        transConfig.setResoAdjMethod("1");
        MediaTimeIntervalObject timeInterval = request.getTimeInterval();
        timeInterval.setStart("0");
        timeInterval.setDuration("60");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void createMediaTemplateWithAigcMetadata(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTag("Transcode");
        request.setName("mark-test-2");
        request.getContainer().setFormat("mp4");
        MediaVideoObject video = request.getVideo();
        video.setCodec("H.264");
        video.setProfile("high");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        video.setPreset("medium");
        video.setBufSize("1000");
        video.setMaxrate("10");
        MediaAudioObject audio = request.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("1");
        MediaTransConfigObject transConfig = request.getTransConfig();
        transConfig.setAdjDarMethod("scale");
        transConfig.setIsCheckReso("false");
        transConfig.setResoAdjMethod("1");
        AigcMetadata aigcMetadata = transConfig.getAigcMetadata();
        aigcMetadata.setLabel("label");
        aigcMetadata.setContentProducer("testProducer");
        aigcMetadata.setProduceId("testProduceId");
        aigcMetadata.setReservedCode1(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setReservedCode2(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setPropagateId("testPropagateId");
        aigcMetadata.setContentPropagator("testPropagator");
        MediaTimeIntervalObject timeInterval = request.getTimeInterval();
        timeInterval.setStart("0");
        timeInterval.setDuration("60");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void deleteMediaTemplate(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTemplateId("t1619b0381be1a46738796e97fff4*****");
        Boolean response = client.deleteMediaTemplate(request);
        System.out.println(response);
    }

    public static void describeMediaTemplates(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTag("Transcode");
        MediaListTemplateResponse response = client.describeMediaTemplates(request);
        List<MediaTemplateObject> templateList = response.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : templateList) {
            System.out.println(mediaTemplateObject);
        }
    }

    public static void updateMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTemplateId("t138b37dc82e59422d85f03bb7a8*****");
        request.setTag("Transcode");
        request.setName("mark-test-update-01");
        request.getContainer().setFormat("mp4");
        MediaVideoObject video = request.getVideo();
        video.setCodec("H.264");
        video.setProfile("high");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        video.setPreset("medium");
        video.setBufSize("1000");
        video.setMaxrate("10");
        MediaAudioObject audio = request.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("1");
        MediaTransConfigObject transConfig = request.getTransConfig();
        transConfig.setAdjDarMethod("scale");
        transConfig.setIsCheckReso("false");
        transConfig.setResoAdjMethod("1");
        MediaTimeIntervalObject timeInterval = request.getTimeInterval();
        timeInterval.setStart("1");
        timeInterval.setDuration("30");
        Boolean aBoolean = client.updateMediaTemplate(request);
        System.out.println(aBoolean);
    }

    public static void updateMediaTemplateWithAigcMetadata(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTemplateId("t138b37dc82e59422d85f03bb7a8*****");
        request.setTag("Transcode");
        request.setName("mark-test-update-01");
        request.getContainer().setFormat("mp4");
        MediaVideoObject video = request.getVideo();
        video.setCodec("H.264");
        video.setProfile("high");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        video.setPreset("medium");
        video.setBufSize("1000");
        video.setMaxrate("10");
        MediaAudioObject audio = request.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("1");
        MediaTransConfigObject transConfig = request.getTransConfig();
        transConfig.setAdjDarMethod("scale");
        transConfig.setIsCheckReso("false");
        transConfig.setResoAdjMethod("1");
        AigcMetadata aigcMetadata = transConfig.getAigcMetadata();
        aigcMetadata.setLabel("label");
        aigcMetadata.setContentProducer("testProducer");
        aigcMetadata.setProduceId("testProduceId");
        aigcMetadata.setReservedCode1(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setReservedCode2(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setPropagateId("testPropagateId");
        aigcMetadata.setContentPropagator("testPropagator");
        MediaTimeIntervalObject timeInterval = request.getTimeInterval();
        timeInterval.setStart("1");
        timeInterval.setDuration("30");
        Boolean aBoolean = client.updateMediaTemplate(request);
        System.out.println(aBoolean);
    }
}

