/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.geo;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.geo.GeoLibrary;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CountryResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/termora/plugins/geo/Geo;", "Lapp/termora/Disposable;", "<init>", "()V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "reader", "Lcom/maxmind/geoip2/DatabaseReader;", "initialize", "", "country", "Lapp/termora/plugins/geo/Geo$Country;", "ip", "", "isInitialized", "", "dispose", "Companion", "Country", "geo"})
public final class Geo
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    @Nullable
    private DatabaseReader reader;
    private static final Logger log = LoggerFactory.getLogger(Geo.class);

    private Geo() {
    }

    private final void initialize() {
        if (this.isInitialized()) {
            return;
        }
        if (this.initialized.compareAndSet(false, true)) {
            try {
                InputStream input = GeoLibrary.getInputStream();
                if (input == null) {
                    throw new IllegalStateException("GeoLite2-Country.mmdb not be found");
                }
                String string = Locale.getDefault().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String locale = StringsKt.replace$default((String)string, (String)"_", (String)"-", (boolean)false, (int)4, null);
                Object[] objectArray = new String[]{locale, "en"};
                this.reader = new DatabaseReader.Builder(input).locales(CollectionsKt.listOf((Object[])objectArray)).withCache((NodeCache)new CHMCache()).build();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Failed to initialize geo database", (Throwable)e);
                }
                this.initialized.set(false);
            }
        }
    }

    @Nullable
    public final Country country(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        try {
            this.initialize();
            DatabaseReader databaseReader = this.reader;
            if (databaseReader == null) {
                return null;
            }
            DatabaseReader reader = databaseReader;
            Optional optional = reader.tryCountry(InetAddress.getByName(ip));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"tryCountry(...)");
            CountryResponse countryResponse = (CountryResponse)OptionalsKt.getOrNull((Optional)optional);
            if (countryResponse == null) {
                return null;
            }
            CountryResponse response = countryResponse;
            String isoCode = response.getCountry().getIsoCode();
            String name = response.getCountry().getName();
            if (name != null && name.length() > 6) {
                name = isoCode;
            }
            Intrinsics.checkNotNull((Object)isoCode);
            String string = name;
            if (string == null) {
                string = isoCode;
            }
            return new Country(isoCode, string);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Failed to initialize geo database", (Throwable)e);
            }
            return null;
        }
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public void dispose() {
        IOUtils.closeQuietly((Closeable)((Closeable)this.reader));
    }

    public /* synthetic */ Geo(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/geo/Geo$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/plugins/geo/Geo;", "geo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Geo getInstance() {
            return (Geo)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(Geo.class), Companion::getInstance$lambda$0);
        }

        private static final Geo getInstance$lambda$0() {
            return new Geo(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lapp/termora/plugins/geo/Geo$Country;", "", "isoCode", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getIsoCode", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "geo"})
    public static final class Country {
        @NotNull
        private final String isoCode;
        @NotNull
        private final String name;

        public Country(@NotNull String isoCode, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)isoCode, (String)"isoCode");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.isoCode = isoCode;
            this.name = name;
        }

        @NotNull
        public final String getIsoCode() {
            return this.isoCode;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.isoCode;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Country copy(@NotNull String isoCode, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)isoCode, (String)"isoCode");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Country(isoCode, name);
        }

        public static /* synthetic */ Country copy$default(Country country, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = country.isoCode;
            }
            if ((n & 2) != 0) {
                string2 = country.name;
            }
            return country.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Country(isoCode=" + this.isoCode + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.isoCode.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Country)) {
                return false;
            }
            Country country = (Country)other;
            if (!Intrinsics.areEqual((Object)this.isoCode, (Object)country.isoCode)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)country.name);
        }
    }
}

