/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.FieldCompletion;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.MethodCompletion;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.FieldInfo;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DescWindowCallback;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.Util;

public class JavadocUrlHandler
implements ExternalURLHandler {
    private static final System.Logger LOG = System.getLogger(JavadocUrlHandler.class.getName());

    private String doBackups(String pkg, int backupCount) {
        int lastDot = pkg.length();
        while (lastDot > -1 && backupCount > 0) {
            lastDot = pkg.lastIndexOf(46, lastDot);
            --backupCount;
        }
        return lastDot > -1 ? pkg.substring(0, lastDot) : "";
    }

    private JavaLanguageSupport getJavaLanguageSupport() {
        return (JavaLanguageSupport)LanguageSupportFactory.get().getSupportFor("text/java");
    }

    private static String getAnchor(String url) {
        int pound = url.indexOf(35);
        return pound > -1 ? url.substring(pound + 1) : null;
    }

    private static String[] getArgs(String methodSignature) {
        int rparen;
        String[] args = null;
        int lparen = methodSignature.indexOf(40);
        if (lparen > -1 && (rparen = methodSignature.indexOf(41, lparen)) > -1 && rparen > lparen + 1) {
            String temp = methodSignature.substring(lparen, rparen);
            args = temp.split("\\s*,\\s*");
        }
        if (args == null) {
            args = new String[]{};
        }
        return args;
    }

    private String getClass(Completion c, String desc) {
        String clazz = null;
        if (c instanceof ClassCompletion) {
            clazz = ((ClassCompletion)c).getClassName(true);
        } else if (c instanceof MemberCompletion) {
            MemberCompletion mc = (MemberCompletion)c;
            clazz = mc.getEnclosingClassName(true);
        } else {
            JavadocUrlHandler.logError("Can't determine class from completion type: " + c.getClass() + " (" + c + ") - href: " + desc);
        }
        return clazz;
    }

    private String getPackage(Completion c, String desc) {
        String pkg = null;
        if (c instanceof ClassCompletion) {
            pkg = ((ClassCompletion)c).getPackageName();
        } else if (c instanceof MemberCompletion) {
            int lastDot;
            String definedIn = ((MemberCompletion)c).getEnclosingClassName(true);
            if (definedIn != null && (lastDot = definedIn.lastIndexOf(46)) > -1) {
                pkg = definedIn.substring(0, lastDot);
            }
        } else {
            JavadocUrlHandler.logError("Can't determine package from completion type: " + c.getClass() + " (" + c + ") - href: " + desc);
        }
        return pkg;
    }

    private boolean isRelativeUrl(String text) {
        String[] extensions;
        for (String ext : extensions = new String[]{".html", ".htm"}) {
            if (!text.endsWith(ext) && !text.contains(ext + "#") && !text.contains(ext + "?")) continue;
            return true;
        }
        return false;
    }

    private static void logError(String text) {
        LOG.log(System.Logger.Level.ERROR, text);
    }

    public void urlClicked(HyperlinkEvent e, Completion c, DescWindowCallback callback) {
        URL url = e.getURL();
        if (url != null) {
            try {
                Util.browse((URI)new URI(url.toString()));
            }
            catch (URISyntaxException ioe) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                ioe.printStackTrace();
            }
            return;
        }
        String desc = e.getDescription();
        if (desc != null) {
            if (this.isRelativeUrl(desc)) {
                int ext = desc.indexOf(".htm");
                if (ext > -1) {
                    String anchor = JavadocUrlHandler.getAnchor(desc);
                    Object clazz = desc.substring(0, ext);
                    int backups = 0;
                    while (((String)clazz).startsWith("../")) {
                        ++backups;
                        clazz = ((String)clazz).substring(3);
                    }
                    clazz = ((String)clazz).replace('/', '.');
                    String pkg = this.getPackage(c, desc);
                    if (pkg != null) {
                        clazz = this.doBackups(pkg, backups) + "." + (String)clazz;
                        JavaLanguageSupport jls = this.getJavaLanguageSupport();
                        ClassFile cf = jls.getJarManager().getClassEntry((String)clazz);
                        if (cf != null) {
                            ClassCompletion cc = new ClassCompletion(c.getProvider(), cf);
                            callback.showSummaryFor((Completion)cc, anchor);
                        }
                    }
                }
            } else {
                JavaLanguageSupport jls = this.getJavaLanguageSupport();
                Object clazz = desc;
                String member = null;
                int pound = desc.indexOf(35);
                if (pound > -1) {
                    member = ((String)clazz).substring(pound + 1);
                    clazz = ((String)clazz).substring(0, pound);
                }
                if (member == null) {
                    ClassFile cf;
                    boolean guessedPackage = false;
                    if (((String)clazz).indexOf(46) == -1) {
                        String pkg = this.getPackage(c, desc);
                        if (pkg != null) {
                            clazz = pkg + "." + (String)clazz;
                        }
                        guessedPackage = true;
                    }
                    if ((cf = jls.getJarManager().getClassEntry((String)clazz)) == null && guessedPackage) {
                        int lastDot = ((String)clazz).lastIndexOf(46);
                        clazz = "java.lang." + ((String)clazz).substring(lastDot + 1);
                        cf = jls.getJarManager().getClassEntry((String)clazz);
                    }
                    if (cf != null) {
                        ClassCompletion cc = new ClassCompletion(c.getProvider(), cf);
                        callback.showSummaryFor((Completion)cc, null);
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                        JavadocUrlHandler.logError("Unknown class: " + (String)clazz);
                    }
                } else {
                    boolean guessedPackage = false;
                    if (pound == 0) {
                        clazz = this.getClass(c, desc);
                    } else if (((String)clazz).indexOf(46) == -1) {
                        String pkg = this.getPackage(c, desc);
                        if (pkg != null) {
                            clazz = pkg + "." + (String)clazz;
                        }
                        guessedPackage = true;
                    }
                    ClassFile cf = jls.getJarManager().getClassEntry((String)clazz);
                    if (cf == null && guessedPackage) {
                        int lastDot = ((String)clazz).lastIndexOf(46);
                        clazz = "java.lang." + ((String)clazz).substring(lastDot + 1);
                        cf = jls.getJarManager().getClassEntry((String)clazz);
                    }
                    if (cf != null) {
                        MemberCompletion memberCompletion = null;
                        int lparen = member.indexOf(40);
                        if (lparen == -1) {
                            FieldInfo fi = cf.getFieldInfoByName(member);
                            if (fi != null) {
                                memberCompletion = new FieldCompletion(c.getProvider(), fi);
                            } else {
                                List<MethodInfo> miList = cf.getMethodInfoByName(member, -1);
                                if (miList != null && !miList.isEmpty()) {
                                    MethodInfo mi = miList.get(0);
                                    memberCompletion = new MethodCompletion(c.getProvider(), mi);
                                }
                            }
                        } else {
                            String[] args = JavadocUrlHandler.getArgs(member);
                            String methodName = member.substring(0, lparen);
                            List<MethodInfo> miList = cf.getMethodInfoByName(methodName, args.length);
                            if (miList != null && !miList.isEmpty()) {
                                if (miList.size() > 1) {
                                    JavadocUrlHandler.logError("Multiple overload support not yet implemented");
                                } else {
                                    MethodInfo mi = miList.get(0);
                                    memberCompletion = new MethodCompletion(c.getProvider(), mi);
                                }
                            }
                        }
                        if (memberCompletion != null) {
                            callback.showSummaryFor((Completion)memberCompletion, null);
                        }
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                        JavadocUrlHandler.logError("Unknown class: " + (String)clazz + " (href: " + desc + ")");
                    }
                }
            }
        }
    }
}

