/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.js.engine;

import java.util.HashMap;
import java.util.Map;
import org.fife.rsta.ac.js.engine.ECMAJavaScriptEngine;
import org.fife.rsta.ac.js.engine.JSR223JavaScriptEngine;
import org.fife.rsta.ac.js.engine.JavaScriptEngine;
import org.fife.rsta.ac.js.engine.RhinoJavaScriptEngine;

public final class JavaScriptEngineFactory {
    public static final String DEFAULT = "ECMA";
    private Map<String, JavaScriptEngine> supportedEngines = new HashMap<String, JavaScriptEngine>();
    private static final JavaScriptEngineFactory INSTANCE = new JavaScriptEngineFactory();

    private JavaScriptEngineFactory() {
    }

    public static JavaScriptEngineFactory instance() {
        return INSTANCE;
    }

    public JavaScriptEngine getEngineFromCache(String name) {
        if (name == null) {
            name = DEFAULT;
        }
        return this.supportedEngines.get(name);
    }

    public void addEngine(String name, JavaScriptEngine engine) {
        this.supportedEngines.put(name, engine);
    }

    public void removeEngine(String name) {
        this.supportedEngines.remove(name);
    }

    static {
        JavaScriptEngineFactory.instance().addEngine(DEFAULT, new ECMAJavaScriptEngine());
        JavaScriptEngineFactory.instance().addEngine("JSR223", new JSR223JavaScriptEngine());
        JavaScriptEngineFactory.instance().addEngine("RHINO", new RhinoJavaScriptEngine());
    }
}

