/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.bg;

import app.termora.GlassPaneExtension;
import app.termora.Graphics2DKt;
import app.termora.WindowScope;
import app.termora.plugin.DispatchThread;
import app.termora.plugins.bg.Appearance;
import app.termora.plugins.bg.BackgroundManager;
import com.formdev.flatlaf.FlatLaf;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/plugins/bg/BGGlassPaneExtension;", "Lapp/termora/GlassPaneExtension;", "<init>", "()V", "paint", "", "scope", "Lapp/termora/WindowScope;", "c", "Ljavax/swing/JComponent;", "g2d", "Ljava/awt/Graphics2D;", "Companion", "bg"})
public final class BGGlassPaneExtension
implements GlassPaneExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BGGlassPaneExtension instance = new BGGlassPaneExtension();

    private BGGlassPaneExtension() {
    }

    public void paint(@NotNull WindowScope scope, @NotNull JComponent c, @NotNull Graphics2D g2d) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        BufferedImage bufferedImage = BackgroundManager.Companion.getInstance().getBackgroundImage();
        if (bufferedImage == null) {
            return;
        }
        BufferedImage img = bufferedImage;
        Graphics2DKt.save((Graphics2D)g2d);
        g2d.setComposite(AlphaComposite.getInstance(3, FlatLaf.isLafDark() ? 0.2f : 0.1f));
        switch (Appearance.INSTANCE.getFillMode()) {
            case "STRETCH": {
                g2d.drawImage(img, 0, 0, c.getWidth(), c.getHeight(), null);
                break;
            }
            case "CENTER": {
                int x = (c.getWidth() - img.getWidth()) / 2;
                int y = (c.getHeight() - img.getHeight()) / 2;
                g2d.drawImage((Image)img, x, y, null);
                break;
            }
            case "TILE": {
                int iw = img.getWidth();
                int ih = img.getHeight();
                for (int y = 0; y < c.getHeight(); y += ih) {
                    for (int x = 0; x < c.getWidth(); x += iw) {
                        g2d.drawImage((Image)img, x, y, null);
                    }
                }
                break;
            }
            case "FIT": {
                double scale = Math.max((double)c.getWidth() / (double)img.getWidth(), (double)c.getHeight() / (double)img.getHeight());
                int newW = (int)((double)img.getWidth() * scale);
                int newH = (int)((double)img.getHeight() * scale);
                int x = (c.getWidth() - newW) / 2;
                int y = (c.getHeight() - newH) / 2;
                g2d.drawImage(img, x, y, newW, newH, null);
            }
        }
        Graphics2DKt.restore((Graphics2D)g2d);
    }

    public long ordered() {
        return super.ordered();
    }

    @NotNull
    public DispatchThread getDispatchThread() {
        return super.getDispatchThread();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/plugins/bg/BGGlassPaneExtension$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/bg/BGGlassPaneExtension;", "getInstance", "()Lapp/termora/plugins/bg/BGGlassPaneExtension;", "bg"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BGGlassPaneExtension getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

